/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.apikey.config;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableWebMvc
class ApikeyMailConfig
extends WebMvcConfigurerAdapter {
    private static final String APIKEY_USAGE = "The API key can be used for regular API request, see https://pro.europeana.eu/resources/apis/intro#access";
    private static final String SECRET_USAGE = "while the API key and Secret key together authenticate the Keycloak Client used to authenticate for specific API methods that require additional authentication.";
    private static final String MESSAGEFOOTER = "%n%nPlease keep a safe record of these key(s) and do not share them with third parties or expose it in user interfaces or in markup, as the API key(s) are confidential and are for use by the client or user only.%n%nOur technical documentation for all APIs is available at https://pro.europeana.eu/resources/apis which includes an API console for testing and community developed libraries for a variety of programming languages.%n%nPlease join us in the Europeana API Forum (https://groups.google.com/forum/?pli=1#!forum/europeanaapi) - to ask questions to us and other developers and to give us your feedback on our API. You can also contact us directly by mailing api@europeana.eu and we would be especially grateful if you would let us know about your implementation so that we can feature it in our application gallery on Europeana Pro - https://pro.europeana.eu/resources/apps.%n%nBest regards,%nThe Europeana API Team";
    private static final String SEPARATOR = "===========================%n";
    private static final String LONGSEPARATOR = "====================================================%n";
    private static final String LONGERSEPARATOR = "================================================================%n";
    @Value(value="${europeana.mail.from}")
    private String sentFrom;
    @Value(value="${europeana.mail.bcc}")
    private String copyTo;

    ApikeyMailConfig() {
    }

    @Bean(value={"apikeyTemplate"})
    public SimpleMailMessage apikeyCreatedMail() {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setSubject("Your Europeana API key");
        message.setText("Dear %s %s,%n%nThank you for registering for the Europeana API.%nThis is your Europeana API key: %n%n===========================%nAPI key: \t%s %n===========================%n%n%nThe API key can be used for regular API request, see https://pro.europeana.eu/resources/apis/intro#access.%n%nPlease keep a safe record of these key(s) and do not share them with third parties or expose it in user interfaces or in markup, as the API key(s) are confidential and are for use by the client or user only.%n%nOur technical documentation for all APIs is available at https://pro.europeana.eu/resources/apis which includes an API console for testing and community developed libraries for a variety of programming languages.%n%nPlease join us in the Europeana API Forum (https://groups.google.com/forum/?pli=1#!forum/europeanaapi) - to ask questions to us and other developers and to give us your feedback on our API. You can also contact us directly by mailing api@europeana.eu and we would be especially grateful if you would let us know about your implementation so that we can feature it in our application gallery on Europeana Pro - https://pro.europeana.eu/resources/apps.%n%nBest regards,%nThe Europeana API Team");
        message.setFrom(this.sentFrom);
        if (StringUtils.isNotEmpty((CharSequence)this.copyTo)) {
            message.setBcc(this.copyTo);
        }
        return message;
    }

    @Bean(value={"apikeyAndClientTemplate"})
    public SimpleMailMessage apikeyAndClientCreatedMail() {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setSubject("Your Europeana API keys");
        message.setText("Dear %s %s,%n%nThank you for registering for the Europeana API.%nThese are your Europeana API keys: %n%n====================================================%nAPI key: \t\t%s %nSecret key: \t%s %n====================================================%n%n%nThe API key can be used for regular API request, see https://pro.europeana.eu/resources/apis/intro#access, while the API key and Secret key together authenticate the Keycloak Client used to authenticate for specific API methods that require additional authentication.%n%nPlease keep a safe record of these key(s) and do not share them with third parties or expose it in user interfaces or in markup, as the API key(s) are confidential and are for use by the client or user only.%n%nOur technical documentation for all APIs is available at https://pro.europeana.eu/resources/apis which includes an API console for testing and community developed libraries for a variety of programming languages.%n%nPlease join us in the Europeana API Forum (https://groups.google.com/forum/?pli=1#!forum/europeanaapi) - to ask questions to us and other developers and to give us your feedback on our API. You can also contact us directly by mailing api@europeana.eu and we would be especially grateful if you would let us know about your implementation so that we can feature it in our application gallery on Europeana Pro - https://pro.europeana.eu/resources/apps.%n%nBest regards,%nThe Europeana API Team");
        message.setFrom(this.sentFrom);
        if (StringUtils.isNotEmpty((CharSequence)this.copyTo)) {
            message.setBcc(this.copyTo);
        }
        return message;
    }

    @Bean(value={"clientTemplate"})
    public SimpleMailMessage clientAddedMail() {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setSubject("Keycloak authentication was added to your Europeana API key");
        message.setText("Dear %s %s,%n%nThank you for requesting a secret key for the Europeana API.%nThis secret key is intended to be used together with your existing Europeana API key:%n%n================================================================%nYour existing API key is: \t%s %nYour new secret key is: \t%s %n================================================================%n%n%nThe API key can be used for regular API request, see https://pro.europeana.eu/resources/apis/intro#access, while the API key and Secret key together authenticate the Keycloak Client used to authenticate for specific API methods that require additional authentication.%n%nPlease keep a safe record of these key(s) and do not share them with third parties or expose it in user interfaces or in markup, as the API key(s) are confidential and are for use by the client or user only.%n%nOur technical documentation for all APIs is available at https://pro.europeana.eu/resources/apis which includes an API console for testing and community developed libraries for a variety of programming languages.%n%nPlease join us in the Europeana API Forum (https://groups.google.com/forum/?pli=1#!forum/europeanaapi) - to ask questions to us and other developers and to give us your feedback on our API. You can also contact us directly by mailing api@europeana.eu and we would be especially grateful if you would let us know about your implementation so that we can feature it in our application gallery on Europeana Pro - https://pro.europeana.eu/resources/apps.%n%nBest regards,%nThe Europeana API Team");
        message.setFrom(this.sentFrom);
        if (StringUtils.isNotEmpty((CharSequence)this.copyTo)) {
            message.setBcc(this.copyTo);
        }
        return message;
    }
}

