/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.apikey.captcha;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.apikey.exception.CaptchaException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CaptchaManager {
    private static final Logger LOG = LogManager.getLogger(CaptchaManager.class);
    @Value(value="${recaptcha.verification-url.scheme}")
    private String verificationUrlScheme;
    @Value(value="${recaptcha.verification-url.host}")
    private String verificationUrlHost;
    @Value(value="${recaptcha.verification-url.path}")
    private String verificationUrlPath;
    @Value(value="${recaptcha.secret}")
    private String secret;
    private CloseableHttpClient httpClient;

    @PostConstruct
    public void init() {
        this.httpClient = HttpClients.createDefault();
    }

    public boolean verifyCaptchaToken(String captchaToken) throws EuropeanaApiException {
        String verificationResponse = this.getVerificationResponse(captchaToken);
        LOG.debug("Captcha verification response = {} ", (Object)verificationResponse);
        if (verificationResponse != null) {
            JSONObject jsonObject = new JSONObject(verificationResponse);
            if (!jsonObject.getBoolean("success")) {
                JSONArray jsonArray = jsonObject.getJSONArray("error-codes");
                LOG.error("Captcha verification error: {} ", jsonArray.get(0));
                throw new CaptchaException(jsonArray.get(0).toString());
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVerificationResponse(String captchaToken) {
        LOG.debug("Sending captcha verification...");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpPost(this.getVerificationURI(captchaToken)));){
            LOG.debug("Received captcha verification");
            if (response.getStatusLine().getStatusCode() != 200) return null;
            String string = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (URISyntaxException e) {
            LOG.error("Wrong URI syntax.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.error("Captcha verification request failed.", (Throwable)e);
        }
        return null;
    }

    private URI getVerificationURI(String captchaToken) throws URISyntaxException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.verificationUrlScheme).setHost(this.verificationUrlHost).setPath(this.verificationUrlPath).setParameter("secret", this.secret).setParameter("response", captchaToken);
        return builder.build();
    }

    @PreDestroy
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            LOG.warn("Closing httpClient failed", (Throwable)e);
        }
    }
}

