/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.search.model.ResultSet;
import eu.europeana.corelib.web.exception.EuropeanaException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Deprecated
@Controller
public class RedirectController {
    private static final Logger LOG = LogManager.getLogger(RedirectController.class);
    private SearchService searchService;

    @Autowired
    public RedirectController(SearchService searchService) {
        this.searchService = searchService;
    }

    @GetMapping(value={"/{apiKey}/redirect", "/{apiKey}/redirect.json", "/v2/{apiKey}/redirect", "/v2/{apiKey}/redirect.json"})
    public Object handleRedirect(@PathVariable String apiKey, @RequestParam(value="shownAt") String isShownAt, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)isShownAt)) {
            return this.generateError(response, "Empty 'shownAt' parameter", apiKey);
        }
        if (this.isInEuropeana(isShownAt)) {
            return "redirect:" + isShownAt;
        }
        return this.generateError(response, "Can't redirect: '" + isShownAt + "' is not a known 'shownAt' url", apiKey);
    }

    private ModelAndView generateError(HttpServletResponse response, String msg, String apiKey) {
        response.setStatus(400);
        LOG.error(msg);
        return JsonUtils.toJson((Object)new ApiError(apiKey, msg));
    }

    private boolean isInEuropeana(String url) {
        try {
            Query query = new Query("provider_aggregation_edm_isShownAt:\"" + ClientUtils.escapeQueryChars((String)url) + "\"").setApiQuery(true).setFacetsAllowed(false).setSpellcheckAllowed(false).setSort(null);
            ResultSet resultSet = this.searchService.search(BriefBean.class, query);
            LOG.debug("Redirect query = {}", (Object)query.getExecutedQuery());
            return resultSet.getResultSize() > 0L;
        }
        catch (EuropeanaException ste) {
            LOG.error("Error checking if url is in Solr index", (Throwable)ste);
            return true;
        }
    }
}

