/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils.technicalfacets;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import eu.europeana.api2.v2.utils.technicalfacets.TagEncoding;
import eu.europeana.corelib.definitions.model.Orientation;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImageTagExtractor {
    private static final Logger LOG = LogManager.getLogger((String)ImageTagExtractor.class.getName());
    public static final BiMap<String, Integer> hexColors = HashBiMap.create((int)139);

    public static Integer getSizeCode(Integer width, Integer height) {
        if (width == null || height == null) {
            return 0;
        }
        long size = width * height;
        if (size < 524288L) {
            return 1;
        }
        if (size < 0x100000L) {
            return 2;
        }
        if (size < 0x400000L) {
            return 3;
        }
        return 4;
    }

    public static Integer getSizeCode(String imageSize) {
        if (StringUtils.isBlank((CharSequence)imageSize)) {
            return 0;
        }
        switch (imageSize) {
            case "small": {
                return 1;
            }
            case "medium": {
                return 2;
            }
            case "large": {
                return 3;
            }
            case "extra_large": {
                return 4;
            }
        }
        return 0;
    }

    public static String getSize(int tag) {
        int sizeCode = TagEncoding.IMAGE_SIZE.extractValue(tag);
        switch (sizeCode) {
            case 1: {
                return "small";
            }
            case 2: {
                return "medium";
            }
            case 3: {
                return "large";
            }
            case 4: {
                return "extra_large";
            }
        }
        return "";
    }

    public static Integer getColorSpaceCode(String colorSpace) {
        if (StringUtils.isBlank((CharSequence)colorSpace)) {
            return 0;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)colorSpace, (CharSequence)"rgb")) {
            return 1;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)colorSpace, (CharSequence)"gray") || colorSpace.toLowerCase().contains("grey")) {
            return 2;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)colorSpace, (CharSequence)"cmyk")) {
            return 3;
        }
        return 0;
    }

    public static Integer getColorSpaceCode(Boolean imageColor, Boolean imageGrayScale) {
        if (imageColor == null && imageGrayScale == null) {
            return 0;
        }
        if (imageGrayScale != null && imageGrayScale.booleanValue()) {
            return 2;
        }
        if (imageColor != null && imageColor.booleanValue()) {
            return 1;
        }
        return 3;
    }

    public static String getColorSpace(int tag) {
        int colorSpaceCode = TagEncoding.IMAGE_COLOURSPACE.extractValue(tag);
        if (2 == colorSpaceCode) {
            return "false";
        }
        if (1 == colorSpaceCode || 3 == colorSpaceCode) {
            return "true";
        }
        return "";
    }

    public static Integer getAspectRatioCode(Orientation orientation) {
        if (orientation == null) {
            return 0;
        }
        if (orientation == Orientation.PORTRAIT) {
            return 1;
        }
        if (orientation == Orientation.LANDSCAPE) {
            return 2;
        }
        return 0;
    }

    public static String getAspectRatio(int tag) {
        int aspectRatioCode = TagEncoding.IMAGE_ASPECTRATIO.extractValue(tag);
        switch (aspectRatioCode) {
            case 1: {
                return Orientation.getValue((Orientation)Orientation.PORTRAIT);
            }
            case 2: {
                return Orientation.getValue((Orientation)Orientation.LANDSCAPE);
            }
        }
        return "";
    }

    public static Integer getColorCode(String colour) {
        if (StringUtils.isBlank((CharSequence)colour)) {
            return 0;
        }
        if (hexColors.containsKey((Object)colour)) {
            return (Integer)hexColors.get((Object)colour);
        }
        return 0;
    }

    public static String getColor(int tag) {
        Integer colorCode = TagEncoding.IMAGE_COLOUR.extractValue(tag);
        return (String)StringUtils.defaultIfEmpty((CharSequence)((CharSequence)hexColors.inverse().get((Object)colorCode)), (CharSequence)"");
    }

    static {
        hexColors.put((Object)"", (Object)0);
        hexColors.put((Object)"#F0F8FF", (Object)1);
        hexColors.put((Object)"#FAEBD7", (Object)2);
        hexColors.put((Object)"#00FFFF", (Object)3);
        hexColors.put((Object)"#7FFFD4", (Object)4);
        hexColors.put((Object)"#F0FFFF", (Object)5);
        hexColors.put((Object)"#F5F5DC", (Object)6);
        hexColors.put((Object)"#FFE4C4", (Object)7);
        hexColors.put((Object)"#000000", (Object)8);
        hexColors.put((Object)"#FFEBCD", (Object)9);
        hexColors.put((Object)"#0000FF", (Object)10);
        hexColors.put((Object)"#8A2BE2", (Object)11);
        hexColors.put((Object)"#A52A2A", (Object)12);
        hexColors.put((Object)"#DEB887", (Object)13);
        hexColors.put((Object)"#5F9EA0", (Object)14);
        hexColors.put((Object)"#7FFF00", (Object)15);
        hexColors.put((Object)"#D2691E", (Object)16);
        hexColors.put((Object)"#FF7F50", (Object)17);
        hexColors.put((Object)"#6495ED", (Object)18);
        hexColors.put((Object)"#FFF8DC", (Object)19);
        hexColors.put((Object)"#DC143C", (Object)20);
        hexColors.put((Object)"#00008B", (Object)21);
        hexColors.put((Object)"#008B8B", (Object)22);
        hexColors.put((Object)"#B8860B", (Object)23);
        hexColors.put((Object)"#A9A9A9", (Object)24);
        hexColors.put((Object)"#006400", (Object)25);
        hexColors.put((Object)"#BDB76B", (Object)26);
        hexColors.put((Object)"#8B008B", (Object)27);
        hexColors.put((Object)"#556B2F", (Object)28);
        hexColors.put((Object)"#FF8C00", (Object)29);
        hexColors.put((Object)"#9932CC", (Object)30);
        hexColors.put((Object)"#8B0000", (Object)31);
        hexColors.put((Object)"#E9967A", (Object)32);
        hexColors.put((Object)"#8FBC8F", (Object)33);
        hexColors.put((Object)"#483D8B", (Object)34);
        hexColors.put((Object)"#2F4F4F", (Object)35);
        hexColors.put((Object)"#00CED1", (Object)36);
        hexColors.put((Object)"#9400D3", (Object)37);
        hexColors.put((Object)"#FF1493", (Object)38);
        hexColors.put((Object)"#00BFFF", (Object)39);
        hexColors.put((Object)"#696969", (Object)40);
        hexColors.put((Object)"#1E90FF", (Object)41);
        hexColors.put((Object)"#B22222", (Object)42);
        hexColors.put((Object)"#FFFAF0", (Object)43);
        hexColors.put((Object)"#228B22", (Object)44);
        hexColors.put((Object)"#FF00FF", (Object)45);
        hexColors.put((Object)"#DCDCDC", (Object)46);
        hexColors.put((Object)"#F8F8FF", (Object)47);
        hexColors.put((Object)"#FFD700", (Object)48);
        hexColors.put((Object)"#DAA520", (Object)49);
        hexColors.put((Object)"#808080", (Object)50);
        hexColors.put((Object)"#008000", (Object)51);
        hexColors.put((Object)"#ADFF2F", (Object)52);
        hexColors.put((Object)"#F0FFF0", (Object)53);
        hexColors.put((Object)"#FF69B4", (Object)54);
        hexColors.put((Object)"#CD5C5C", (Object)55);
        hexColors.put((Object)"#4B0082", (Object)56);
        hexColors.put((Object)"#FFFFF0", (Object)57);
        hexColors.put((Object)"#F0E68C", (Object)58);
        hexColors.put((Object)"#E6E6FA", (Object)59);
        hexColors.put((Object)"#FFF0F5", (Object)60);
        hexColors.put((Object)"#7CFC00", (Object)61);
        hexColors.put((Object)"#FFFACD", (Object)62);
        hexColors.put((Object)"#ADD8E6", (Object)63);
        hexColors.put((Object)"#F08080", (Object)64);
        hexColors.put((Object)"#E0FFFF", (Object)65);
        hexColors.put((Object)"#FAFAD2", (Object)66);
        hexColors.put((Object)"#D3D3D3", (Object)67);
        hexColors.put((Object)"#90EE90", (Object)68);
        hexColors.put((Object)"#FFB6C1", (Object)69);
        hexColors.put((Object)"#FFA07A", (Object)70);
        hexColors.put((Object)"#20B2AA", (Object)71);
        hexColors.put((Object)"#87CEFA", (Object)72);
        hexColors.put((Object)"#778899", (Object)73);
        hexColors.put((Object)"#B0C4DE", (Object)74);
        hexColors.put((Object)"#FFFFE0", (Object)75);
        hexColors.put((Object)"#00FF00", (Object)76);
        hexColors.put((Object)"#32CD32", (Object)77);
        hexColors.put((Object)"#FAF0E6", (Object)78);
        hexColors.put((Object)"#800000", (Object)79);
        hexColors.put((Object)"#66CDAA", (Object)80);
        hexColors.put((Object)"#0000CD", (Object)81);
        hexColors.put((Object)"#BA55D3", (Object)82);
        hexColors.put((Object)"#9370DB", (Object)83);
        hexColors.put((Object)"#3CB371", (Object)84);
        hexColors.put((Object)"#7B68EE", (Object)85);
        hexColors.put((Object)"#00FA9A", (Object)86);
        hexColors.put((Object)"#48D1CC", (Object)87);
        hexColors.put((Object)"#C71585", (Object)88);
        hexColors.put((Object)"#191970", (Object)89);
        hexColors.put((Object)"#F5FFFA", (Object)90);
        hexColors.put((Object)"#FFE4E1", (Object)91);
        hexColors.put((Object)"#FFE4B5", (Object)92);
        hexColors.put((Object)"#FFDEAD", (Object)93);
        hexColors.put((Object)"#000080", (Object)94);
        hexColors.put((Object)"#FDF5E6", (Object)95);
        hexColors.put((Object)"#808000", (Object)96);
        hexColors.put((Object)"#6B8E23", (Object)97);
        hexColors.put((Object)"#FFA500", (Object)98);
        hexColors.put((Object)"#FF4500", (Object)99);
        hexColors.put((Object)"#DA70D6", (Object)100);
        hexColors.put((Object)"#EEE8AA", (Object)101);
        hexColors.put((Object)"#98FB98", (Object)102);
        hexColors.put((Object)"#AFEEEE", (Object)103);
        hexColors.put((Object)"#DB7093", (Object)104);
        hexColors.put((Object)"#FFEFD5", (Object)105);
        hexColors.put((Object)"#FFDAB9", (Object)106);
        hexColors.put((Object)"#CD853F", (Object)107);
        hexColors.put((Object)"#FFC0CB", (Object)108);
        hexColors.put((Object)"#DDA0DD", (Object)109);
        hexColors.put((Object)"#B0E0E6", (Object)110);
        hexColors.put((Object)"#800080", (Object)111);
        hexColors.put((Object)"#FF0000", (Object)112);
        hexColors.put((Object)"#BC8F8F", (Object)113);
        hexColors.put((Object)"#4169E1", (Object)114);
        hexColors.put((Object)"#8B4513", (Object)115);
        hexColors.put((Object)"#FA8072", (Object)116);
        hexColors.put((Object)"#F4A460", (Object)117);
        hexColors.put((Object)"#2E8B57", (Object)118);
        hexColors.put((Object)"#FFF5EE", (Object)119);
        hexColors.put((Object)"#A0522D", (Object)120);
        hexColors.put((Object)"#C0C0C0", (Object)121);
        hexColors.put((Object)"#87CEEB", (Object)122);
        hexColors.put((Object)"#6A5ACD", (Object)123);
        hexColors.put((Object)"#708090", (Object)124);
        hexColors.put((Object)"#FFFAFA", (Object)125);
        hexColors.put((Object)"#00FF7F", (Object)126);
        hexColors.put((Object)"#4682B4", (Object)127);
        hexColors.put((Object)"#D2B48C", (Object)128);
        hexColors.put((Object)"#008080", (Object)129);
        hexColors.put((Object)"#D8BFD8", (Object)130);
        hexColors.put((Object)"#FF6347", (Object)131);
        hexColors.put((Object)"#40E0D0", (Object)132);
        hexColors.put((Object)"#EE82EE", (Object)133);
        hexColors.put((Object)"#F5DEB3", (Object)134);
        hexColors.put((Object)"#FFFFFF", (Object)135);
        hexColors.put((Object)"#F5F5F5", (Object)136);
        hexColors.put((Object)"#FFFF00", (Object)137);
        hexColors.put((Object)"#9ACD32", (Object)138);
    }
}

