/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.QueryTranslationResult;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.definitions.solr.model.QueryTranslation;
import eu.europeana.corelib.search.utils.SearchUtils;
import eu.europeana.corelib.utils.StringArrayUtils;
import eu.europeana.corelib.web.exception.EuropeanaException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@SwaggerSelect
@Api(tags={"Search"})
public class QueryTranslationController {
    @Resource
    private ApiKeyUtils apiKeyUtils;
    private static final String ERROR_TERM = "Invalid parameter: term can not be empty";
    private static final String ERROR_LANGUAGE = "Invalid parameter: languageCodes can not be empty";

    @ApiOperation(value="translate a term to different languages")
    @GetMapping(value={"/v2/translateQuery.json"}, produces={"application/json"})
    public ModelAndView translateQuery(@RequestParam(value="term", required=true) String term, @RequestParam(value="languageCodes", required=true) String[] languageCodes, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="profile", required=false) String profile, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) throws EuropeanaException {
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        languageCodes = StringArrayUtils.splitWebParameter((String[])languageCodes);
        LimitResponse limitResponse = this.apiKeyUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.TRANSLATE_QUERY, null);
        if (StringUtils.isBlank((CharSequence)term)) {
            response.setStatus(400);
            return JsonUtils.toJson((Object)new ApiError(wskey, ERROR_TERM), (String)callback);
        }
        if (StringArrayUtils.isBlank((String[])languageCodes)) {
            response.setStatus(400);
            return JsonUtils.toJson((Object)new ApiError(wskey, ERROR_LANGUAGE), (String)callback);
        }
        QueryTranslationResult queryTranslationResult = new QueryTranslationResult(wskey, limitResponse.getRequestNumber());
        QueryTranslation queryTranslation = SearchUtils.translateQuery((String)term, Arrays.asList(languageCodes));
        queryTranslationResult.translations = queryTranslation.getLanguageVersions();
        queryTranslationResult.translatedQuery = queryTranslation.getModifiedQuery();
        if (StringUtils.isNotBlank((CharSequence)profile) && StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)"param")) {
            queryTranslationResult.addParam("wskey", (Object)wskey);
            queryTranslationResult.addParam("term", (Object)term);
            queryTranslationResult.addParam("languageCodes", (Object)languageCodes);
            queryTranslationResult.addParam("profile", (Object)profile);
            queryTranslationResult.addParam("callback", (Object)callback);
        }
        return JsonUtils.toJson((Object)queryTranslationResult, (String)callback);
    }
}

