/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.ApiKeyException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.model.utils.Api2UrlService;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.utils.XmlUtils;
import eu.europeana.api2.v2.model.xml.rss.Channel;
import eu.europeana.api2.v2.model.xml.rss.RssResponse;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.api2.v2.web.controller.GlobalExceptionHandler;
import eu.europeana.corelib.edm.exceptions.SolrIOException;
import eu.europeana.corelib.edm.exceptions.SolrQueryException;
import eu.europeana.corelib.web.exception.EuropeanaException;
import eu.europeana.corelib.web.service.EmailService;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger LOG = LogManager.getLogger(GlobalExceptionHandler.class);
    private static final Pattern EUROPEANA_URL = Pattern.compile("(at )?((https?:\\/\\/)?[a-zA-Z0-9-_/.]*(\\.eanadev\\.org|\\.europeana\\.eu))(:[a-zA-Z0-9-_/.]*)?");
    private static final String API_KEY_PARAM = "wskey";
    @Resource(name="corelib_web_emailService")
    private EmailService emailService;
    @Resource(name="api2_mvc_xmlUtils")
    private XmlUtils xmlUtils;

    @ExceptionHandler(value={EuropeanaException.class})
    public ModelAndView europeanaExceptionHandler(HttpServletRequest request, HttpServletResponse response, EuropeanaException ee) {
        try {
            String wskey = request.getParameter(API_KEY_PARAM);
            this.mailLogOrIgnoreError(wskey, ee);
            response.setStatus(this.getHttpStatus(response, ee));
            return this.generateErrorResponse(request, response, ee.getMessage(), ee.getErrorDetails(), ee.getErrorCode());
        }
        catch (Exception ex) {
            LOG.error("Error while generating error response", (Throwable)ex);
            throw ex;
        }
    }

    private void mailLogOrIgnoreError(String apiKey, EuropeanaException ee) {
        switch (1.$SwitchMap$eu$europeana$corelib$web$exception$ProblemResponseAction[ee.getAction().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                LOG.warn("[{}] {}", (Object)apiKey, (Object)ee.getErrorMsgAndDetails());
                break;
            }
            case 3: {
                this.sendErrorEmail(ee);
                break;
            }
            default: {
                LOG.error(ee.getErrorMsgAndDetails(), (Throwable)ee);
            }
        }
    }

    private void sendErrorEmail(EuropeanaException ee) {
        String subject = "Exception in Search API " + Api2UrlService.getBeanInstance().getApi2BaseUrl();
        String body = ee.getErrorMsgAndDetails() + "/n" + ExceptionUtils.getStackTrace((Throwable)ee);
        LOG.info("Exception email was not sent (temporary disabled)");
    }

    private int getHttpStatus(HttpServletResponse response, EuropeanaException ee) {
        if (response.getStatus() != 200) {
            return response.getStatus();
        }
        int result = 500;
        if (ee instanceof ApiKeyException) {
            result = 401;
        } else if (ee instanceof SolrQueryException) {
            result = 400;
        } else if (ee instanceof SolrIOException) {
            result = 503;
        }
        return result;
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ModelAndView missingParameterErrorHandler(HttpServletRequest request, HttpServletResponse response, MissingServletRequestParameterException ex) {
        String errorMsg;
        response.setStatus(400);
        if (API_KEY_PARAM.equalsIgnoreCase(ex.getParameterName())) {
            response.setStatus(401);
            errorMsg = "No API key provided";
        } else {
            errorMsg = "Required parameter '" + ex.getParameterName() + "' missing";
        }
        return this.generateErrorResponse(request, response, errorMsg, null, null);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ModelAndView mediaTypeNotAcceptableHandler(HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(406);
        String requestedMediaType = ControllerUtils.getRequestedMediaType((HttpServletRequest)request);
        String errorMsg = "The resource identified by this request cannot generate a response of type " + requestedMediaType;
        return this.generateErrorResponse(request, response, errorMsg, null, null);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ModelAndView mediaTypeNotSupportedHandler(HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(415);
        String requestedContentType = ControllerUtils.getRequestedContentType((HttpServletRequest)request);
        String errorMsg = "Content type '" + requestedContentType + " not supported";
        return this.generateErrorResponse(request, response, errorMsg, null, null);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class, MethodArgumentNotValidException.class, MissingServletRequestPartException.class, TypeMismatchException.class})
    public ModelAndView badRequestHandler(HttpServletRequest request, HttpServletResponse response, Exception e) {
        response.setStatus(400);
        return this.generateErrorResponse(request, response, e.getMessage(), null, null);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ModelAndView unsupportedMethodHandler(HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(405);
        String errorMsg = "Request method '" + request.getMethod() + "' is not allowed for the requested resource";
        return this.generateErrorResponse(request, response, errorMsg, null, null);
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView defaultExceptionHandler(HttpServletRequest request, HttpServletResponse response, Exception e) {
        try {
            LOG.error("Caught unexpected exception", (Throwable)e);
            response.setStatus(500);
            String errorMsg = "Internal server error";
            String errorDetails = e.getMessage();
            return this.generateErrorResponse(request, response, errorMsg, errorDetails, null);
        }
        catch (Exception ex) {
            LOG.error("Error while generating error response", (Throwable)ex);
            throw ex;
        }
    }

    private ModelAndView generateErrorResponse(HttpServletRequest request, HttpServletResponse response, String errorMsg, String errorDetails, String errorCode) {
        response.setCharacterEncoding("UTF-8");
        String requestFormat = ControllerUtils.getRequestFormat((HttpServletRequest)request);
        String details = this.filterSensitiveInfo(errorDetails);
        if ("RDF".equalsIgnoreCase(requestFormat)) {
            response.setContentType("application/rdf+xml");
            return this.generateRdfError(errorMsg, details);
        }
        if ("RSS".equalsIgnoreCase(requestFormat)) {
            response.setContentType("application/xml");
            return this.generateRssError(errorMsg, details);
        }
        return this.generateJsonError(request, errorMsg, details, errorCode);
    }

    private ModelAndView generateRdfError(String errorMessage, String errorDetails) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("error", errorMessage);
        model.put("errorDetails", errorDetails);
        return new ModelAndView("rdf", model);
    }

    private ModelAndView generateRssError(String errorMessage, String errorDetails) {
        RssResponse response = new RssResponse();
        Channel channel = response.channel;
        channel.setTitle("Error");
        channel.setDescription(errorMessage + (StringUtils.isEmpty((String)errorDetails) ? "" : " - " + errorDetails));
        channel.setAtomLink(null);
        channel.setLink(null);
        channel.totalResults = null;
        channel.startIndex = null;
        channel.itemsPerPage = null;
        channel.query = null;
        channel.image = null;
        String xml = this.xmlUtils.toString((Object)response);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("rss", xml);
        return new ModelAndView("rss", model);
    }

    private ModelAndView generateJsonError(HttpServletRequest request, String errorMsg, String errorDetails, String errorCode) {
        String wskey = request.getParameter(API_KEY_PARAM);
        String callback = request.getParameter("callback");
        return JsonUtils.toJson((Object)new ApiError(wskey, errorMsg, errorDetails, errorCode), (String)callback);
    }

    private String filterSensitiveInfo(String errorMsg) {
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            return EUROPEANA_URL.matcher(errorMsg).replaceAll("-");
        }
        return errorMsg;
    }
}

