/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils.technicalfacets;

import eu.europeana.api2.v2.utils.technicalfacets.TagEncoding;
import org.apache.commons.lang3.StringUtils;

public class SoundTagExtractor {
    private SoundTagExtractor() {
    }

    public static Integer getQualityCode(Integer bitDepth, Integer sampleRate, String fileFormat) {
        if (bitDepth != null && sampleRate != null && bitDepth >= 16 && sampleRate >= 44100) {
            return 1;
        }
        if (fileFormat != null && (fileFormat.equalsIgnoreCase("alac") || fileFormat.equalsIgnoreCase("flac") || fileFormat.equalsIgnoreCase("ape") || fileFormat.equalsIgnoreCase("shn") || fileFormat.equalsIgnoreCase("wav") || fileFormat.equalsIgnoreCase("wma") || fileFormat.equalsIgnoreCase("aiff") || fileFormat.equalsIgnoreCase("dsd"))) {
            return 1;
        }
        return 0;
    }

    public static Integer getQualityCode(String soundHQ) {
        return StringUtils.containsIgnoreCase((CharSequence)soundHQ, (CharSequence)"true") ? 1 : 0;
    }

    public static String getQuality(Integer tag) {
        int qualityCode = TagEncoding.SOUND_QUALITY.extractValue(tag.intValue());
        if (1 == qualityCode) {
            return "true";
        }
        return "";
    }

    public static Integer getDurationCode(String duration) {
        if (StringUtils.isBlank((CharSequence)duration)) {
            return 0;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)duration, (CharSequence)"very_short")) {
            return 1;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)duration, (CharSequence)"short")) {
            return 2;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)duration, (CharSequence)"medium")) {
            return 3;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)duration, (CharSequence)"long")) {
            return 4;
        }
        return 0;
    }

    private static Integer getDurationCode(Long duration) {
        if (duration == null) {
            return 0;
        }
        if (duration <= 30000L) {
            return 1;
        }
        if (duration <= 180000L) {
            return 2;
        }
        if (duration <= 360000L) {
            return 3;
        }
        return 4;
    }

    public static String getDuration(Integer tag) {
        int durationCode = TagEncoding.SOUND_DURATION.extractValue(tag.intValue());
        switch (durationCode) {
            case 1: {
                return "very_short";
            }
            case 2: {
                return "short";
            }
            case 3: {
                return "medium";
            }
            case 4: {
                return "long";
            }
        }
        return "";
    }
}

