/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.ApiKeyException;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.db.entity.relational.ApiKeyImpl;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.db.entity.relational.enums.ApiClientLevel;
import eu.europeana.corelib.web.exception.ProblemType;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.exception.JDBCConnectionException;
import org.springframework.transaction.CannotCreateTransactionException;

public class ApiKeyUtils {
    private static final Logger LOG = LogManager.getLogger(ApiKeyUtils.class);
    @Resource
    private ApiKeyService apiService;

    public LimitResponse checkLimit(String wskey, String url, RecordType recordType, String profile) throws ApiKeyException {
        ApiKey apiKey;
        if (StringUtils.isBlank((CharSequence)wskey)) {
            throw new ApiKeyException(ProblemType.APIKEY_MISSING, null);
        }
        long requestNumber = 0L;
        try {
            long t = System.currentTimeMillis();
            apiKey = (ApiKey)this.apiService.findByID((Serializable)((Object)wskey));
            if (apiKey == null) {
                throw new ApiKeyException(ProblemType.APIKEY_INVALID, wskey);
            }
            LOG.debug("Get apiKey took {} ms", (Object)(System.currentTimeMillis() - t));
            requestNumber = 999L;
            LOG.debug("Setting default request number; (checklimit disabled): {} ", (Object)requestNumber);
        }
        catch (DatabaseException e) {
            LOG.error("Error retrieving apikey", (Throwable)e);
            ApiKeyException ex = new ApiKeyException(ProblemType.APIKEY_INVALID, wskey);
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (JDBCConnectionException | CannotCreateTransactionException ex) {
            LOG.error("Unable to validate apikey", ex);
            requestNumber = 998L;
            apiKey = new ApiKeyImpl();
            apiKey.setApiKey(wskey);
            apiKey.setDescription("Temporary key");
            apiKey.setLevel(ApiClientLevel.CLIENT);
        }
        return new LimitResponse(apiKey, requestNumber);
    }
}

