/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonUtils {
    private static final Logger log = Logger.getLogger(JsonUtils.class);

    public static ModelAndView toJson(Object object) {
        return JsonUtils.toJson((Object)object, null);
    }

    private static ModelAndView toJsonOrLd(String json, boolean isJsonLd, String callback) {
        String resultPage = isJsonLd ? "jsonld" : "json";
        LinkedHashMap<String, String> model = new LinkedHashMap<String, String>();
        model.put(resultPage, json);
        if (StringUtils.isNotBlank((CharSequence)callback)) {
            resultPage = "jsonp";
            model.put("callback", callback);
        }
        return new ModelAndView(resultPage, model);
    }

    public static ModelAndView toJson(String json, String callback) {
        return JsonUtils.toJsonOrLd((String)json, (boolean)false, (String)callback);
    }

    public static ModelAndView toJsonLd(String json, String callback) {
        return JsonUtils.toJsonOrLd((String)json, (boolean)true, (String)callback);
    }

    public static ModelAndView toJson(Object object, String callback) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return JsonUtils.toJson((String)objectMapper.writeValueAsString(object), (String)callback);
        }
        catch (JsonProcessingException e) {
            log.error((Object)("Json Generation Exception: " + e.getMessage()), (Throwable)e);
            String resultPage = "json";
            LinkedHashMap<String, String> model = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)callback)) {
                resultPage = "jsonp";
                model.put("callback", callback);
            }
            return new ModelAndView(resultPage, model);
        }
    }
}

