/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.controller.mydata;

import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.json.ModificationConfirmation;
import eu.europeana.api2.v2.model.json.UserResults;
import eu.europeana.api2.v2.model.json.abstracts.UserObject;
import eu.europeana.api2.v2.model.json.user.SavedItem;
import eu.europeana.api2.web.controller.abstracts.AbstractUserController;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.definitions.db.entity.relational.abstracts.EuropeanaUserObject;
import eu.europeana.corelib.neo4j.exception.Neo4JException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Api(value="my_data", description=" ")
@Deprecated
public class MyDataItemController
extends AbstractUserController {
    @ApiOperation(value="lets the user list their data items", nickname="listMyDataItems")
    @RequestMapping(value={"/mydata/saveditem"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView list(@RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserResults response = new UserResults(principal.getName());
        try {
            User user = this.getUserByApiId(principal.getName());
            if (user != null) {
                HashSet<eu.europeana.corelib.definitions.db.entity.relational.SavedItem> results;
                response.items = new ArrayList();
                response.username = user.getUserName();
                if (StringUtils.isBlank((CharSequence)europeanaId)) {
                    results = user.getSavedItems();
                } else {
                    results = new HashSet<eu.europeana.corelib.definitions.db.entity.relational.SavedItem>();
                    results.add(this.userService.findSavedItemByEuropeanaId((Long)user.getId(), europeanaId));
                }
                response.itemsCount = results.size();
                for (eu.europeana.corelib.definitions.db.entity.relational.SavedItem item : results) {
                    SavedItem fav = new SavedItem();
                    this.copyUserObjectData(response.apikey, (UserObject)fav, (EuropeanaUserObject)item);
                    fav.author = item.getAuthor();
                    response.items.add(fav);
                }
            } else {
                response.success = false;
                response.error = "Invalid credentials";
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="lets the user create a new data item", nickname="createMyDataItem")
    @RequestMapping(value={"/mydata/saveditem"}, produces={"application/json"}, method={RequestMethod.POST})
    public ModelAndView create(@RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(principal.getName());
        try {
            User user = this.getUserByApiId(principal.getName());
            if (user != null) {
                this.userService.createSavedItem((Long)user.getId(), europeanaId);
                response.success = true;
            } else {
                response.success = false;
                response.error = "Invalid credentials";
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        catch (Neo4JException e) {
            e.printStackTrace();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="lets the user delete a data item", nickname="deleteMyDataItem")
    @RequestMapping(value={"/mydata/saveditem"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ModelAndView delete(@RequestParam(value="itemid", required=false) Long itemId, @RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(principal.getName());
        try {
            User user = this.getUserByApiId(principal.getName());
            if (user != null) {
                response.success = true;
                if (itemId != null) {
                    this.userService.removeSavedItem((Long)user.getId(), itemId);
                } else if (StringUtils.isNotBlank((CharSequence)europeanaId)) {
                    this.userService.removeSavedItem((Long)user.getId(), europeanaId);
                } else {
                    response.success = false;
                    response.error = "Invalid arguments";
                }
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }
}

