/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.v2.web.SiteMapNotFoundException;
import eu.europeana.features.ObjectStorageClient;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Deprecated
public class SitemapController {
    private static final Logger LOG = Logger.getLogger(SitemapController.class);
    private static final String INDEX_FILE = "europeana-sitemap-index-hashed.xml";
    private static final String ACTIVE_SITEMAP_FILE = "europeana-sitemap-active-xml-file.txt";
    private ObjectStorageClient objectStorageClient;

    @RequestMapping(value={"/europeana-sitemap-index-hashed.xml"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"text/xml"})
    public String handleSitemapIndex(HttpServletResponse response) throws IOException {
        try {
            return this.getFileContents(INDEX_FILE);
        }
        catch (SiteMapNotFoundException e) {
            LOG.error((Object)"Sitemap index file not found", (Throwable)e);
            response.sendError(404);
            return null;
        }
    }

    @RequestMapping(value={"/europeana-sitemap-hashed.xml"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"text/xml"})
    public String handleSitemapFile(@RequestParam(value="from") String from, @RequestParam(value="to") String to, HttpServletResponse response) throws IOException {
        try {
            String fileName = this.getActiveDeployment() + "?from=" + from + "&to=" + to;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Retrieving sitemap file " + fileName));
            }
            return this.getFileContents(fileName);
        }
        catch (SiteMapNotFoundException e) {
            LOG.error((Object)"Sitemap file not found", (Throwable)e);
            response.sendError(404);
            return null;
        }
    }

    private String getFileContents(String file) throws SiteMapNotFoundException, IOException {
        if (!this.objectStorageClient.getWithoutBody(file).isPresent()) {
            throw new SiteMapNotFoundException("File " + file + " not found!");
        }
        return new String(this.objectStorageClient.getContent(file), "UTF-8");
    }

    private String getActiveDeployment() throws SiteMapNotFoundException, IOException {
        return this.getFileContents(ACTIVE_SITEMAP_FILE);
    }
}

