/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.utils.ControllerUtils;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class ExceptionControllerAdvice {
    private static final Logger LOG = LogManager.getLogger(ExceptionControllerAdvice.class);

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ModelAndView missingParameterErrorHandler(HttpServletRequest request, HttpServletResponse response, MissingServletRequestParameterException ex) {
        ModelAndView result;
        String errorMsg;
        response.setStatus(400);
        String requestFormat = ControllerUtils.getRequestFormat((HttpServletRequest)request);
        if ("wskey".equalsIgnoreCase(ex.getParameterName())) {
            response.setStatus(401);
            errorMsg = "No API key provided";
        } else {
            errorMsg = "Required parameter '" + ex.getParameterName() + "' missing";
        }
        if ("RDF".equalsIgnoreCase(requestFormat)) {
            result = this.generateRdfError(errorMsg);
        } else {
            if ("SRW".equalsIgnoreCase(requestFormat)) {
                return null;
            }
            result = JsonUtils.toJson((Object)new ApiError("", errorMsg));
        }
        return result;
    }

    @ExceptionHandler(value={ApiLimitException.class})
    public ModelAndView apiLimitErrorHandler(HttpServletRequest request, HttpServletResponse response, ApiLimitException e) {
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        response.setStatus(e.getHttpStatus());
        String requestFormat = ControllerUtils.getRequestFormat((HttpServletRequest)request);
        if ("RDF".equalsIgnoreCase(requestFormat)) {
            return this.generateRdfError("Unregistered API key");
        }
        if ("SRW".equalsIgnoreCase(requestFormat)) {
            return null;
        }
        return JsonUtils.toJson((Object)new ApiError(e), (String)request.getParameter("callback"));
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ModelAndView mediaTypeNotAcceptableHandler(HttpServletRequest request, HttpServletResponse response, HttpMediaTypeNotAcceptableException e) {
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        response.setStatus(406);
        String requestedMediaType = ControllerUtils.getRequestedMediaType((HttpServletRequest)request);
        String errorMsg = "The resource identified by this request cannot generate a response of type " + requestedMediaType;
        return JsonUtils.toJson((Object)new ApiError("", errorMsg));
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ModelAndView mediaTypeNotSupportedHandler(HttpServletRequest request, HttpServletResponse response, HttpMediaTypeNotSupportedException e) {
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        response.setStatus(415);
        String requestedContentType = ControllerUtils.getRequestedContentType((HttpServletRequest)request);
        String errorMsg = "Content type '" + requestedContentType + " not supported";
        return JsonUtils.toJson((Object)new ApiError("", errorMsg));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class, MethodArgumentNotValidException.class, MissingServletRequestPartException.class, TypeMismatchException.class})
    public ModelAndView badRequestHandler(HttpServletResponse response, Exception e) {
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        response.setStatus(400);
        return JsonUtils.toJson((Object)new ApiError("", e.getMessage()));
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ModelAndView unsupportedMethodHandler(HttpServletRequest request, HttpServletResponse response, HttpRequestMethodNotSupportedException e) {
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        response.setStatus(405);
        String errorMsg = "Request method '" + request.getMethod() + "' is not allowed for the requested resource";
        return JsonUtils.toJson((Object)new ApiError("", errorMsg));
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView defaultExceptionHandler(HttpServletRequest request, HttpServletResponse response, Exception e) throws Exception {
        LOG.error("Caught exception: {}", (Throwable)e);
        response.setStatus(500);
        String requestFormat = ControllerUtils.getRequestFormat((HttpServletRequest)request);
        if ("RDF".equalsIgnoreCase(requestFormat)) {
            return this.generateRdfError("Internal server error");
        }
        if ("SRW".equalsIgnoreCase(requestFormat)) {
            throw e;
        }
        String wskey = request.getParameter("wskey");
        String callback = request.getParameter("callback");
        return JsonUtils.toJson((Object)new ApiError(wskey, e.getClass().getSimpleName() + ": " + e.getMessage()), (String)callback);
    }

    private ModelAndView generateRdfError(String errorMessage) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("error", errorMessage);
        return new ModelAndView("rdf", model);
    }
}

