/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.db.entity.relational.ApiKeyImpl;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.db.entity.relational.enums.ApiClientLevel;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.exception.JDBCConnectionException;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.CannotCreateTransactionException;

public class ApiKeyUtils {
    private static final Logger LOG = LogManager.getLogger(ApiKeyUtils.class);
    @Resource
    private ApiKeyService apiService;

    public LimitResponse checkLimit(String wskey, String url, RecordType recordType, String profile) throws ApiLimitException {
        ApiKey apiKey;
        if (StringUtils.isBlank((CharSequence)wskey)) {
            throw new ApiLimitException(wskey, "No API key provided", 0L, HttpStatus.UNAUTHORIZED.value());
        }
        long requestNumber = 0L;
        try {
            long t = System.currentTimeMillis();
            apiKey = (ApiKey)this.apiService.findByID((Serializable)((Object)wskey));
            if (apiKey == null) {
                throw new ApiLimitException(wskey, "Invalid API key", 0L, HttpStatus.UNAUTHORIZED.value());
            }
            LOG.debug("Get apiKey took {} ms", (Object)(System.currentTimeMillis() - t));
            requestNumber = 999L;
            LOG.debug("Setting default request number; (checklimit disabled): {} ", (Object)requestNumber);
        }
        catch (DatabaseException e) {
            LOG.error("Error retrieving apikey", (Throwable)e);
            ApiLimitException ex = new ApiLimitException(wskey, e.getMessage(), requestNumber, HttpStatus.UNAUTHORIZED.value());
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (JDBCConnectionException | CannotCreateTransactionException ex) {
            LOG.error("Unable to validate apikey", ex);
            requestNumber = 998L;
            apiKey = new ApiKeyImpl();
            apiKey.setApiKey(wskey);
            apiKey.setDescription("Temporary key");
            apiKey.setLevel(ApiClientLevel.CLIENT);
        }
        return new LimitResponse(apiKey, requestNumber);
    }
}

