/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service;

import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.HierarchicalResult;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.neo4j.Neo4jSearchService;
import eu.europeana.corelib.neo4j.entity.Neo4jStructBean;
import eu.europeana.corelib.neo4j.exception.Neo4JException;
import eu.europeana.corelib.web.exception.EmailServiceException;
import eu.europeana.corelib.web.exception.EuropeanaException;
import eu.europeana.corelib.web.exception.ProblemType;
import eu.europeana.corelib.web.service.EmailService;
import eu.europeana.corelib.web.utils.RequestUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.servlet.ModelAndView;

public class HierarchyRunner {
    private static final Logger LOG = LogManager.getLogger(HierarchyRunner.class);
    private static final int MAX_LIMIT = 100;
    private static final String SUBJECTPREFIX = "Europeana exception email handler: ";
    @Resource(name="corelib_web_emailService")
    private EmailService emailService;
    private Neo4jSearchService searchService;

    @Async
    public ModelAndView call(RecordType recordType, String rdfAbout, String profile, String wskey, int limit, int offset, String callback, HttpServletRequest request, HttpServletResponse response, ApiKeyUtils apiKeyUtils, Neo4jSearchService searchService) {
        LimitResponse limitResponse;
        this.searchService = searchService;
        LOG.debug("Running thread for {}", (Object)rdfAbout);
        long selfIndex = 0L;
        long t0 = System.currentTimeMillis();
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        limit = Math.min(limit, 100);
        long t1 = System.currentTimeMillis();
        try {
            limitResponse = apiKeyUtils.checkLimit(wskey, request.getRequestURL().toString(), recordType, profile);
        }
        catch (ApiLimitException e) {
            response.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Limit: {}", (Object)(System.currentTimeMillis() - t1));
        }
        t1 = System.currentTimeMillis();
        HierarchicalResult hierarchicalResult = new HierarchicalResult(wskey, limitResponse.getRequestNumber());
        if (StringUtils.containsIgnoreCase((String)profile, (String)"params")) {
            hierarchicalResult.addParams(RequestUtils.getParameterMap((HttpServletRequest)request), new String[]{"wskey"});
            hierarchicalResult.addParam("profile", (Object)profile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Init object: {}", (Object)(System.currentTimeMillis() - t1));
        }
        t1 = System.currentTimeMillis();
        try {
            hierarchicalResult.self = searchService.getSingle(rdfAbout);
            if (hierarchicalResult.self != null) {
                if (hierarchicalResult.self.hasChildren().booleanValue() && hierarchicalResult.self.getChildrenCount() == 0L) {
                    throw new Neo4JException(ProblemType.NEO4J_502, " for record " + rdfAbout);
                }
            } else {
                hierarchicalResult.success = false;
                response.setStatus(404);
                return JsonUtils.toJson((Object)new ApiError(wskey, "Invalid record identifier: " + rdfAbout, limitResponse.getRequestNumber()), (String)callback);
            }
            selfIndex = hierarchicalResult.self.getIndex();
            if (LOG.isDebugEnabled()) {
                LOG.debug("get self: {} ", (Object)(System.currentTimeMillis() - t1));
            }
            t1 = System.currentTimeMillis();
            if (recordType.equals((Object)RecordType.HIERARCHY_CHILDREN)) {
                if (hierarchicalResult.self.getChildrenCount() > 0L) {
                    hierarchicalResult.children = searchService.getChildren(rdfAbout, offset, limit);
                    if (hierarchicalResult.children == null || hierarchicalResult.children.isEmpty()) {
                        hierarchicalResult.message = "This record has no children";
                        hierarchicalResult.success = false;
                        response.setStatus(404);
                    }
                } else {
                    hierarchicalResult.message = "This record has no children";
                    hierarchicalResult.success = false;
                    response.setStatus(404);
                }
            } else if (recordType.equals((Object)RecordType.HIERARCHY_PARENT)) {
                if (hierarchicalResult.self == null || StringUtils.isBlank((String)hierarchicalResult.self.getParent())) {
                    hierarchicalResult.message = "This record has no parent";
                    hierarchicalResult.success = false;
                    response.setStatus(404);
                } else {
                    hierarchicalResult.parent = searchService.getSingle(hierarchicalResult.self.getParent());
                }
            } else if (recordType.equals((Object)RecordType.HIERARCHY_FOLLOWING_SIBLINGS)) {
                hierarchicalResult.followingSiblings = searchService.getFollowingSiblings(rdfAbout, offset, limit, selfIndex);
                if (hierarchicalResult.followingSiblings == null || hierarchicalResult.followingSiblings.isEmpty()) {
                    hierarchicalResult.message = "This record has no following siblings";
                    hierarchicalResult.success = false;
                    response.setStatus(404);
                }
            } else if (recordType.equals((Object)RecordType.HIERARCHY_PRECEDING_SIBLINGS)) {
                hierarchicalResult.precedingSiblings = searchService.getPrecedingSiblings(rdfAbout, offset, limit, selfIndex);
                if (hierarchicalResult.precedingSiblings == null || hierarchicalResult.precedingSiblings.isEmpty()) {
                    hierarchicalResult.message = "This record has no preceding siblings";
                    hierarchicalResult.success = false;
                    response.setStatus(404);
                }
            } else if (recordType.equals((Object)RecordType.HIERARCHY_ANCESTOR_SELF_SIBLINGS)) {
                Neo4jStructBean struct = searchService.getInitialStruct(rdfAbout, selfIndex);
                if (struct == null) {
                    hierarchicalResult.message = "This record has no hierarchical structure " + rdfAbout;
                    hierarchicalResult.success = false;
                    response.setStatus(404);
                } else {
                    String partialErrorMsg = "This record has no";
                    boolean hasParent = true;
                    boolean hasFollowing = true;
                    boolean hasPreceding = true;
                    if (struct.getParents() != null && !struct.getParents().isEmpty()) {
                        List tempParents = struct.getParents();
                        Collections.reverse(tempParents);
                        hierarchicalResult.ancestors = tempParents;
                    } else {
                        hasParent = false;
                    }
                    if (struct.getFollowingSiblings() != null && !struct.getFollowingSiblings().isEmpty()) {
                        hierarchicalResult.followingSiblings = struct.getFollowingSiblings();
                    } else {
                        hasFollowing = false;
                    }
                    if (struct.getPrecedingSiblings() != null && !struct.getPrecedingSiblings().isEmpty()) {
                        hierarchicalResult.precedingSiblings = struct.getPrecedingSiblings();
                    } else {
                        hasPreceding = false;
                    }
                    if (!hasParent) {
                        partialErrorMsg = partialErrorMsg + " parent";
                        if (!hasFollowing || !hasPreceding) {
                            partialErrorMsg = partialErrorMsg + " or";
                        }
                    }
                    if (!hasFollowing && !hasPreceding) {
                        partialErrorMsg = partialErrorMsg + " siblings";
                    } else if (hasFollowing && !hasPreceding) {
                        partialErrorMsg = partialErrorMsg + " preceding siblings";
                    } else if (!hasFollowing) {
                        partialErrorMsg = partialErrorMsg + " following siblings";
                    }
                    if (!(hasParent && hasFollowing && hasPreceding)) {
                        hierarchicalResult.message = partialErrorMsg;
                    }
                    if (struct.getPrecedingSiblingChildren() != null && !struct.getPrecedingSiblingChildren().isEmpty()) {
                        hierarchicalResult.precedingSiblingChildren = struct.getPrecedingSiblingChildren();
                    }
                    if (struct.getFollowingSiblingChildren() != null && !struct.getFollowingSiblingChildren().isEmpty()) {
                        hierarchicalResult.followingSiblingChildren = struct.getFollowingSiblingChildren();
                    }
                }
            }
        }
        catch (Neo4JException e) {
            response.setStatus(404);
            LOG.error("Neo4JException thrown: {}", (Object)e.getMessage());
            if (null != e.getCause()) {
                LOG.error("Cause: {}", e.getCause());
            }
            return JsonUtils.toJson((Object)new ApiError(wskey, e.getMessage(), -1L), (String)callback);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("get main: {}", (Object)(System.currentTimeMillis() - t1));
        }
        t1 = System.currentTimeMillis();
        hierarchicalResult.statsDuration = System.currentTimeMillis() - t0;
        ModelAndView json = JsonUtils.toJson((Object)hierarchicalResult, (String)callback);
        if (LOG.isDebugEnabled()) {
            LOG.debug("toJson: {}", (Object)(System.currentTimeMillis() - t1));
        }
        return json;
    }

    private void sendExceptionEmail(EuropeanaException e) {
        String newline = System.getProperty("line.separator");
        String header = SUBJECTPREFIX + e.getProblem().getMessage();
        String body = e.getMessage() + newline + newline + ExceptionUtils.getStackTrace((Throwable)e);
        try {
            this.emailService.sendException(header, body);
        }
        catch (EmailServiceException es) {
            LOG.error("Error sending email", (Throwable)e);
        }
    }
}

