/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import com.github.jsonldjava.core.JSONLD;
import com.github.jsonldjava.core.JSONLDProcessingError;
import com.github.jsonldjava.core.Options;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.impl.JenaRDFParser;
import com.github.jsonldjava.utils.JSONUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.model.xml.srw.SrwResponse;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.ItemFix;
import eu.europeana.api2.v2.model.json.ObjectResult;
import eu.europeana.api2.v2.model.json.view.FullDoc;
import eu.europeana.api2.v2.model.json.view.FullView;
import eu.europeana.api2.v2.model.xml.srw.Record;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.api2.v2.utils.HttpCacheUtils;
import eu.europeana.api2.v2.web.controller.ObjectController;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.edm.utils.EdmUtils;
import eu.europeana.corelib.edm.utils.SchemaOrgUtils;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.web.exception.EuropeanaException;
import eu.europeana.corelib.web.utils.RequestUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@Api(tags={"Record"})
@RequestMapping(value={"/v2/record"})
@SwaggerSelect
public class ObjectController {
    private static final Logger LOG = Logger.getLogger(ObjectController.class);
    private static final String ALLOWED = "GET, HEAD";
    private static final String ALLOWHEADERS = "If-Match, If-None-Match, If-Modified-Since";
    private static final String EXPOSEHEADERS = "Allow, ETag, Last-Modified, Link";
    private static final String MEDIA_TYPE_RDF_UTF8 = "application/rdf+xml; charset=UTF-8";
    private static final String ALLOWORIGIN = "*";
    private static final String MAXAGE = "600";
    private static final String NOCACHE = "no_cache";
    private SearchService searchService;
    private ApiKeyUtils apiKeyUtils;
    private HttpCacheUtils httpCacheUtils;

    @Autowired
    public ObjectController(SearchService searchService, ApiKeyUtils apiKeyUtils, HttpCacheUtils httpCacheUtils) {
        this.searchService = searchService;
        this.apiKeyUtils = apiKeyUtils;
        this.httpCacheUtils = httpCacheUtils;
    }

    @ApiOperation(value="get a single record in JSON format", nickname="getSingleRecordJson")
    @GetMapping(value={"/{collectionId}/{recordId}.json"}, produces={"application/json;charset=UTF-8"})
    public ModelAndView record(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="full") String profile, @RequestParam(value="wskey") String wskey, @RequestParam(value="callback", required=false) String callback, @ApiIgnore WebRequest webRequest, @ApiIgnore HttpServletRequest servletRequest, @ApiIgnore HttpServletResponse response) throws ApiLimitException {
        RequestData data = new RequestData(collectionId, recordId, wskey, profile, callback, webRequest, servletRequest);
        try {
            return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT, data, response);
        }
        catch (EuropeanaException e) {
            LOG.error((Object)"Error retrieving record JSON", (Throwable)e);
            response.setStatus(500);
            return JsonUtils.toJson((Object)new ApiError(wskey, ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage(), data.apikeyCheckResponse.getRequestNumber()), (String)data.callback);
        }
    }

    @SwaggerIgnore
    @GetMapping(value={"/context.jsonld", "/context.json-ld"}, produces={"application/json"})
    public ModelAndView contextJSONLD(@RequestParam(value="callback", required=false) String callback) {
        String jsonld = JSONUtils.toString((Object)this.getJsonContext());
        return JsonUtils.toJson((String)jsonld, (String)callback);
    }

    @SwaggerIgnore
    @GetMapping(value={"/{collectionId}/{recordId}.json-ld"}, produces={"application/json"})
    public ModelAndView recordJSON_LD(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey") String wskey, @RequestParam(value="format", required=false, defaultValue="compacted") String format, @RequestParam(value="callback", required=false) String callback, @ApiIgnore WebRequest webRequest, @ApiIgnore HttpServletRequest servletRequest, @ApiIgnore HttpServletResponse response) throws ApiLimitException {
        return this.recordJSONLD(collectionId, recordId, wskey, format, callback, webRequest, servletRequest, response);
    }

    @ApiOperation(value="get single record in JSON LD format", nickname="getSingleRecordJsonLD")
    @GetMapping(value={"/{collectionId}/{recordId}.jsonld"}, produces={"application/json"})
    public ModelAndView recordJSONLD(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey") String wskey, @RequestParam(value="format", required=false, defaultValue="compacted") String format, @RequestParam(value="callback", required=false) String callback, @ApiIgnore WebRequest webRequest, @ApiIgnore HttpServletRequest servletRequest, @ApiIgnore HttpServletResponse response) throws ApiLimitException {
        RequestData data = new RequestData(collectionId, recordId, wskey, format, callback, webRequest, servletRequest);
        try {
            return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_JSONLD, data, response);
        }
        catch (EuropeanaException e) {
            LOG.error((Object)"Error retrieving record JSON-LD", (Throwable)e);
            response.setStatus(500);
            return JsonUtils.toJson((Object)new ApiError(wskey, ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage(), data.apikeyCheckResponse.getRequestNumber()), (String)data.callback);
        }
    }

    @ApiOperation(value="get single record in Schema.org JSON LD format", nickname="getSingleRecordSchemaOrg")
    @GetMapping(value={"/{collectionId}/{recordId}.schema.jsonld"}, produces={"application/json"})
    public ModelAndView recordSchemaOrg(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="format", required=false, defaultValue="compacted") String format, @RequestParam(value="callback", required=false) String callback, @ApiIgnore WebRequest webRequest, @ApiIgnore HttpServletRequest servletRequest, @ApiIgnore HttpServletResponse response) throws ApiLimitException {
        RequestData data = new RequestData(collectionId, recordId, wskey, format, callback, webRequest, servletRequest);
        try {
            return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_SCHEMA_ORG, data, response);
        }
        catch (EuropeanaException e) {
            LOG.error((Object)"Error retrieving record Schema.org JSON-LD", (Throwable)e);
            response.setStatus(500);
            return JsonUtils.toJson((Object)new ApiError(wskey, ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage(), data.apikeyCheckResponse.getRequestNumber()), (String)data.callback);
        }
    }

    @ApiOperation(value="get single record in RDF format)", nickname="getSingleRecordRDF")
    @GetMapping(value={"/{collectionId}/{recordId}.rdf"}, produces={"application/rdf+xml; charset=UTF-8"})
    public ModelAndView recordRdf(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey") String wskey, @ApiIgnore WebRequest webRequest, @ApiIgnore HttpServletRequest servletRequest, @ApiIgnore HttpServletResponse response) throws ApiLimitException {
        RequestData data = new RequestData(collectionId, recordId, wskey, null, null, webRequest, servletRequest);
        try {
            return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_RDF, data, response);
        }
        catch (EuropeanaException e) {
            LOG.error((Object)"Error retrieving record RDF", (Throwable)e);
            response.setStatus(500);
            return JsonUtils.toJson((Object)new ApiError(wskey, ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage(), data.apikeyCheckResponse.getRequestNumber()), (String)data.callback);
        }
    }

    @SwaggerIgnore
    @GetMapping(value={"/{collectionId}/{recordId}.srw"}, produces={"text/xml"})
    @ResponseBody
    public SrwResponse recordSrw(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=false) String wskey, @ApiIgnore WebRequest webRequest, @ApiIgnore HttpServletRequest servletRequest, @ApiIgnore HttpServletResponse response) throws ApiLimitException, EuropeanaException {
        RequestData data = new RequestData(collectionId, recordId, wskey, null, null, webRequest, servletRequest);
        Object out = this.handleRecordRequest(RecordType.OBJECT_SRW, data, response);
        if (out instanceof SrwResponse) {
            return (SrwResponse)out;
        }
        return null;
    }

    private Object handleRecordRequest(RecordType recordType, RequestData data, HttpServletResponse response) throws ApiLimitException, EuropeanaException {
        ModelAndView output;
        if (!StringUtils.equalsIgnoreCase((CharSequence)"GET", (CharSequence)data.servletRequest.getMethod()) && !StringUtils.equalsIgnoreCase((CharSequence)"HEAD", (CharSequence)data.servletRequest.getMethod())) {
            response.setStatus(405);
            return null;
        }
        long startTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving record with id " + data.europeanaObjectId + ", type = " + recordType));
        }
        data.apikeyCheckResponse = this.apiKeyUtils.checkLimit(data.wskey, data.servletRequest.getRequestURL().toString(), recordType, data.profile);
        FullBean bean = this.searchService.fetchFullBean(data.europeanaObjectId);
        if (Objects.isNull(bean)) {
            ModelAndView result;
            response = this.httpCacheUtils.addCorsHeaders(response, ALLOWED, ALLOWHEADERS, EXPOSEHEADERS, MAXAGE, ALLOWORIGIN);
            response.setStatus(404);
            if (recordType == RecordType.OBJECT_RDF) {
                HashMap<String, String> model = new HashMap<String, String>();
                model.put("error", "Non-existing record identifier");
                result = new ModelAndView("rdf", model);
            } else {
                result = recordType == RecordType.OBJECT_SRW ? null : JsonUtils.toJson((Object)new ApiError(data.wskey, "Invalid record identifier: " + data.europeanaObjectId, data.apikeyCheckResponse.getRequestNumber()), (String)data.callback);
            }
            return result;
        }
        String tsUpdated = this.httpCacheUtils.dateToRFC1123String(bean.getTimestampUpdated());
        String eTag = this.httpCacheUtils.generateETag(data.europeanaObjectId + tsUpdated, true, true);
        if (StringUtils.isNotBlank((CharSequence)data.servletRequest.getHeader("If-None-Match"))) {
            if (this.httpCacheUtils.doesAnyIfNoneMatch(data.servletRequest, eTag)) {
                response = this.httpCacheUtils.addDefaultHeaders(response, eTag, tsUpdated, ALLOWED, NOCACHE);
                if (StringUtils.isNotBlank((CharSequence)data.servletRequest.getHeader("Origin"))) {
                    response = this.httpCacheUtils.addCorsHeaders(response, ALLOWED, ALLOWHEADERS, EXPOSEHEADERS, MAXAGE, ALLOWORIGIN);
                }
                response.setStatus(304);
                return null;
            }
        } else if (StringUtils.isNotBlank((CharSequence)data.servletRequest.getHeader("If-Match"))) {
            if (this.httpCacheUtils.doesPreconditionFail(data.servletRequest, eTag)) {
                response.setStatus(412);
                return null;
            }
        } else if (this.httpCacheUtils.isNotModifiedSince(data.servletRequest, bean.getTimestampUpdated())) {
            response.setStatus(304);
            return null;
        }
        ItemFix.apply((FullBean)bean);
        bean = this.searchService.processFullBean(bean, data.europeanaObjectId, false);
        response = this.httpCacheUtils.addDefaultHeaders(response, eTag, tsUpdated, ALLOWED, NOCACHE);
        response = this.httpCacheUtils.addCorsHeaders(response, ALLOWED, ALLOWHEADERS, EXPOSEHEADERS, MAXAGE, ALLOWORIGIN);
        switch (1.$SwitchMap$eu$europeana$corelib$db$entity$enums$RecordType[recordType.ordinal()]) {
            case 1: {
                output = this.generateJson(bean, data, startTime);
                break;
            }
            case 2: {
                output = this.generateJsonLd(bean, data, response);
                break;
            }
            case 3: {
                output = this.generateRdf(bean);
                break;
            }
            case 4: {
                output = this.generateSrw(bean);
                break;
            }
            case 5: {
                output = this.generateSchemaOrg(bean, data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown record output type: " + recordType);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done generating record output in " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return output;
    }

    private ModelAndView generateJson(FullBean bean, RequestData data, long startTime) {
        ObjectResult objectResult = new ObjectResult(data.wskey, data.apikeyCheckResponse.getRequestNumber());
        if (StringUtils.containsIgnoreCase((CharSequence)data.profile, (CharSequence)"params")) {
            objectResult.addParams(RequestUtils.getParameterMap((HttpServletRequest)data.servletRequest), new String[]{"wskey"});
            objectResult.addParam("profile", (Object)data.profile);
        }
        objectResult.object = new FullView(bean, data.profile, data.wskey);
        objectResult.statsDuration = System.currentTimeMillis() - startTime;
        return JsonUtils.toJson((Object)objectResult, (String)data.callback);
    }

    private ModelAndView generateSchemaOrg(FullBean bean, RequestData data) {
        String jsonld = SchemaOrgUtils.toSchemaOrg((FullBeanImpl)((FullBeanImpl)bean));
        return JsonUtils.toJson((String)jsonld, (String)data.callback);
    }

    private ModelAndView generateJsonLd(FullBean bean, RequestData data, HttpServletResponse response) {
        String jsonld = null;
        String rdf = EdmUtils.toEDM((FullBeanImpl)((FullBeanImpl)bean));
        try (InputStream rdfInput = IOUtils.toInputStream((String)rdf);){
            Model modelResult = ModelFactory.createDefaultModel().read(rdfInput, "", "RDF/XML");
            Object raw = JSONLD.fromRDF((Object)modelResult, (RDFParser)new JenaRDFParser());
            if (StringUtils.equalsIgnoreCase((CharSequence)data.profile, (CharSequence)"compacted")) {
                raw = JSONLD.compact((Object)raw, (Object)this.getJsonContext(), (Options)new Options());
            } else if (StringUtils.equalsIgnoreCase((CharSequence)data.profile, (CharSequence)"flattened")) {
                raw = JSONLD.flatten((Object)raw);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)data.profile, (CharSequence)"normalized")) {
                raw = JSONLD.normalize((Object)raw);
            }
            jsonld = JSONUtils.toString((Object)raw);
        }
        catch (JSONLDProcessingError | IOException e) {
            LOG.error((Object)"Error parsing JSON-LD data", e);
            response.setStatus(500);
            return JsonUtils.toJson((Object)new ApiError(data.wskey, e.getClass().getSimpleName() + ": " + e.getMessage()), (String)data.callback);
        }
        return JsonUtils.toJson((String)jsonld, (String)data.callback);
    }

    private ModelAndView generateRdf(FullBean bean) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("record", EdmUtils.toEDM((FullBeanImpl)((FullBeanImpl)bean)));
        return new ModelAndView("rdf", model);
    }

    private SrwResponse generateSrw(FullBean bean) {
        SrwResponse srwResponse = new SrwResponse();
        FullDoc doc = new FullDoc(bean);
        Record record = new Record();
        record.recordData.dc = doc;
        srwResponse.records.record.add(record);
        try {
            this.createXml(srwResponse);
        }
        catch (JAXBException e) {
            LOG.error((Object)"Error generating xml", (Throwable)e);
        }
        return srwResponse;
    }

    private String generateRedirectUrl(HttpServletRequest req, String oldId, String newId) {
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        String requestUri = req.getRequestURI();
        String pathInfo = req.getPathInfo();
        String queryString = req.getQueryString();
        if (!(requestUri = requestUri.replace(oldId, newId)).contains(newId)) {
            throw new IllegalStateException("Error generating record redirect url");
        }
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(':').append(serverPort);
        }
        url.append(requestUri);
        if (pathInfo != null) {
            url.append(pathInfo);
        }
        if (queryString != null) {
            url.append('?').append(queryString);
        }
        return url.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getJsonContext() {
        try (InputStream in = this.getClass().getResourceAsStream("/jsonld/context.jsonld");){
            Object object = JSONUtils.fromInputStream((InputStream)in);
            return object;
        }
        catch (IOException e) {
            LOG.error((Object)"Error reading context.jsonld", (Throwable)e);
            return null;
        }
    }

    private void createXml(SrwResponse response) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SrwResponse.class});
        Marshaller marshaller = context.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)response, (Writer)stringWriter);
    }
}

