/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils.technicalfacets;

import eu.europeana.api2.v2.utils.technicalfacets.TagEncoding;
import org.apache.commons.lang3.StringUtils;

public class VideoTagExtractor {
    private VideoTagExtractor() {
    }

    public static Integer getQualityCode(String videoQuality) {
        return StringUtils.containsIgnoreCase((CharSequence)videoQuality, (CharSequence)"true") ? 1 : 0;
    }

    public static String getQuality(Integer tag) {
        int qualityCode = TagEncoding.VIDEO_QUALITY.extractValue(tag.intValue());
        if (1 == qualityCode) {
            return "true";
        }
        return "";
    }

    public static Integer getDurationCode(String duration) {
        if (StringUtils.isBlank((CharSequence)duration)) {
            return 0;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)duration, (CharSequence)"short")) {
            return 1;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)duration, (CharSequence)"medium")) {
            return 2;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)duration, (CharSequence)"long")) {
            return 3;
        }
        return 0;
    }

    public static String getDuration(Integer tag) {
        int durationCode = TagEncoding.VIDEO_DURATION.extractValue(tag.intValue());
        switch (durationCode) {
            case 1: {
                return "short";
            }
            case 2: {
                return "medium";
            }
            case 3: {
                return "long";
            }
        }
        return "";
    }
}

