/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.v2.utils.technicalfacets.CommonTagExtractor;
import eu.europeana.api2.v2.utils.technicalfacets.ImageTagExtractor;
import eu.europeana.api2.v2.utils.technicalfacets.MediaTypeEncoding;
import eu.europeana.api2.v2.utils.technicalfacets.SoundTagExtractor;
import eu.europeana.api2.v2.utils.technicalfacets.TagEncoding;
import eu.europeana.api2.v2.utils.technicalfacets.VideoTagExtractor;
import eu.europeana.corelib.definitions.model.Orientation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TagUtils {
    private TagUtils() {
    }

    public static List<Integer> imageFilterTags(List<String> imageMimeTypeFacets, List<String> imageSizeFacets, List<String> imageColourSpaceFacets, List<String> imageAspectRatioFacets, List<String> imageColourPaletteFacets) {
        ArrayList<Integer> filterTags = new ArrayList<Integer>();
        TagUtils.fixList(imageMimeTypeFacets).forEach(mimeTypeFacet -> TagUtils.fixList((List)imageSizeFacets).forEach(sizeFacet -> TagUtils.fixList((List)imageColourSpaceFacets).forEach(colourSpaceFacet -> TagUtils.fixList((List)imageAspectRatioFacets).forEach(aspectRatioFacet -> TagUtils.fixList((List)imageColourPaletteFacets).forEach(colourPaletteFacet -> filterTags.add(MediaTypeEncoding.IMAGE.getEncodedValue() | CommonTagExtractor.getMimeTypeCode((String)(mimeTypeFacet.equals("null") ? null : mimeTypeFacet)) << TagEncoding.MIME_TYPE.getBitPos() | ImageTagExtractor.getSizeCode((String)(sizeFacet.equals("null") ? null : sizeFacet)) << TagEncoding.IMAGE_SIZE.getBitPos() | ImageTagExtractor.getColorSpaceCode((String)(colourSpaceFacet.equals("null") ? null : colourSpaceFacet)) << TagEncoding.IMAGE_COLOURSPACE.getBitPos() | ImageTagExtractor.getAspectRatioCode((Orientation)(aspectRatioFacet.equals("null") ? null : TagUtils.getImageOrientation((String)aspectRatioFacet))) << TagEncoding.IMAGE_ASPECTRATIO.getBitPos() | ImageTagExtractor.getColorCode((String)(colourPaletteFacet.equals("null") ? null : colourPaletteFacet)) << TagEncoding.IMAGE_COLOUR.getBitPos()))))));
        return filterTags;
    }

    public static List<Integer> soundFilterTags(List<String> soundMimeTypeFacets, List<String> soundHQFacets, List<String> soundDurationFacets) {
        ArrayList<Integer> filterTags = new ArrayList<Integer>();
        TagUtils.fixList(soundMimeTypeFacets).forEach(mimeTypeFacet -> TagUtils.fixList((List)soundHQFacets).forEach(hqFacet -> TagUtils.fixList((List)soundDurationFacets).forEach(durationFacet -> filterTags.add(MediaTypeEncoding.AUDIO.getEncodedValue() | CommonTagExtractor.getMimeTypeCode((String)(mimeTypeFacet.equals("null") ? null : mimeTypeFacet)) << TagEncoding.MIME_TYPE.getBitPos() | SoundTagExtractor.getQualityCode((String)(hqFacet.equals("null") ? null : hqFacet)) << TagEncoding.SOUND_QUALITY.getBitPos() | SoundTagExtractor.getDurationCode((String)(durationFacet.equals("null") ? null : durationFacet)) << TagEncoding.SOUND_DURATION.getBitPos()))));
        return filterTags;
    }

    public static List<Integer> videoFilterTags(List<String> videoMimeTypeFacets, List<String> videoHDFacets, List<String> videoDurationFacets) {
        ArrayList<Integer> filterTags = new ArrayList<Integer>();
        TagUtils.fixList(videoMimeTypeFacets).forEach(mimeTypeFacet -> TagUtils.fixList((List)videoHDFacets).forEach(hdFacet -> TagUtils.fixList((List)videoDurationFacets).forEach(durationFacet -> filterTags.add(MediaTypeEncoding.VIDEO.getEncodedValue() | CommonTagExtractor.getMimeTypeCode((String)(mimeTypeFacet.equals("null") ? null : mimeTypeFacet)) << TagEncoding.MIME_TYPE.getBitPos() | VideoTagExtractor.getQualityCode((String)(hdFacet.equals("null") ? null : hdFacet)) << TagEncoding.VIDEO_QUALITY.getBitPos() | VideoTagExtractor.getDurationCode((String)(durationFacet.equals("null") ? null : durationFacet)) << TagEncoding.VIDEO_DURATION.getBitPos()))));
        return filterTags;
    }

    public static List<Integer> otherFilterTags(List<String> otherMimeTypeFacets) {
        ArrayList<Integer> filterTags = new ArrayList<Integer>();
        TagUtils.fixList(otherMimeTypeFacets).forEach(mimeTypeFacet -> filterTags.add(MediaTypeEncoding.TEXT.getEncodedValue() | CommonTagExtractor.getMimeTypeCode((String)mimeTypeFacet) << TagEncoding.MIME_TYPE.getBitPos()));
        return filterTags;
    }

    public static List<Integer> colourPaletteFilterTags(List<String> colourPalette) {
        ArrayList<Integer> filterTags = new ArrayList<Integer>();
        TagUtils.fixList(colourPalette).forEach(colour -> filterTags.add(MediaTypeEncoding.IMAGE.getEncodedValue() | ImageTagExtractor.getColorCode((String)colour) << TagEncoding.IMAGE_COLOUR.getBitPos()));
        return filterTags;
    }

    private static List<String> fixList(List<?> fixMe) {
        ArrayList<String> retval = new ArrayList<String>();
        if (fixMe != null && !fixMe.isEmpty()) {
            fixMe.forEach(value -> retval.add(value.toString()));
        } else {
            retval.add("null");
        }
        return new ArrayList<String>(new LinkedHashSet(retval));
    }

    private static Orientation getImageOrientation(String imageAspectRatio) {
        if (StringUtils.isBlank((CharSequence)imageAspectRatio)) {
            return null;
        }
        if (imageAspectRatio.contains("portrait")) {
            return Orientation.PORTRAIT;
        }
        if (imageAspectRatio.contains("landscape")) {
            return Orientation.LANDSCAPE;
        }
        return null;
    }
}

