/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.v2.exceptions.DateMathParseException;
import eu.europeana.api2.v2.exceptions.InvalidGapException;
import eu.europeana.api2.v2.utils.DateMathParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateMathParser {
    private static final TimeZone UTC;
    private static final TimeZone DEFAULT_MATH_TZ;
    private static final DateTimeFormatter PARSER;
    private static final Map<String, ChronoUnit> CALENDAR_UNITS;
    private TimeZone zone;
    private Date now;
    private static Pattern splitter;

    private static Map<String, ChronoUnit> makeUnitsMap() {
        HashMap<String, ChronoUnit> units = new HashMap<String, ChronoUnit>(13);
        units.put("YEAR", ChronoUnit.YEARS);
        units.put("YEARS", ChronoUnit.YEARS);
        units.put("MONTH", ChronoUnit.MONTHS);
        units.put("MONTHS", ChronoUnit.MONTHS);
        units.put("DAY", ChronoUnit.DAYS);
        units.put("DAYS", ChronoUnit.DAYS);
        units.put("DATE", ChronoUnit.DAYS);
        units.put("HOUR", ChronoUnit.HOURS);
        units.put("HOURS", ChronoUnit.HOURS);
        units.put("MINUTE", ChronoUnit.MINUTES);
        units.put("MINUTES", ChronoUnit.MINUTES);
        units.put("SECOND", ChronoUnit.SECONDS);
        units.put("SECONDS", ChronoUnit.SECONDS);
        units.put("MILLI", ChronoUnit.MILLIS);
        units.put("MILLIS", ChronoUnit.MILLIS);
        units.put("MILLISECOND", ChronoUnit.MILLIS);
        units.put("MILLISECONDS", ChronoUnit.MILLIS);
        return units;
    }

    public static long calculateGapCount(String start, String end, String gapMath) throws ParseException {
        Date startDate = DateMathParser.parseNoMath((String)start);
        Date endDate = DateMathParser.parseNoMath((String)end);
        DateMathParser p = new DateMathParser();
        p.setNow(startDate);
        Date gapDate = p.parseMath(gapMath);
        long gapMillis = gapDate.getTime() - startDate.getTime();
        long timespanMillis = endDate.getTime() - startDate.getTime();
        return Math.abs(timespanMillis / gapMillis);
    }

    static void exceedsMaxNrOfGaps(String start, String end, String gapMath, long maxNrOfGaps) throws DateMathParseException, InvalidGapException {
        Date gapDate;
        Date endDate;
        Date startDate;
        String parsing = start;
        String whatsParsed = "start";
        DateMathParser p = new DateMathParser();
        SimpleDateFormat solrDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        solrDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        solrDateFormat.setLenient(false);
        try {
            startDate = solrDateFormat.parse(start);
        }
        catch (ParseException e) {
            throw new DateMathParseException((Throwable)e, parsing, whatsParsed);
        }
        parsing = end;
        whatsParsed = "end";
        try {
            endDate = solrDateFormat.parse(end);
        }
        catch (ParseException e) {
            throw new DateMathParseException((Throwable)e, parsing, whatsParsed);
        }
        p.setNow(startDate);
        parsing = gapMath;
        whatsParsed = "gap";
        try {
            gapDate = p.parseMath(gapMath);
        }
        catch (ParseException e) {
            throw new DateMathParseException((Throwable)e, parsing, whatsParsed);
        }
        long gapMillis = gapDate.getTime() - startDate.getTime();
        long timespanMillis = endDate.getTime() - startDate.getTime();
        long actualNrOfGaps = timespanMillis / gapMillis;
        if (gapMillis < 0L) {
            throw new InvalidGapException("Negative gaps ('" + gapMath + "') cannot be processed");
        }
        if (timespanMillis < 0L) {
            throw new InvalidGapException("The start date ('" + start + "') must be earlier than the end date ('" + end + "')");
        }
        if (actualNrOfGaps > maxNrOfGaps) {
            throw new InvalidGapException("The timespan between '" + start + "' and '" + end + "' contains " + actualNrOfGaps + " gaps of '" + gapMath + "', exceeding the maximum of " + maxNrOfGaps);
        }
    }

    private static LocalDateTime add(LocalDateTime t, int val, String unit) {
        ChronoUnit uu = (ChronoUnit)CALENDAR_UNITS.get(unit);
        if (null == uu) {
            throw new IllegalArgumentException("Adding Unit not recognized: " + unit);
        }
        return t.plus(val, uu);
    }

    private static LocalDateTime round(LocalDateTime t, String unit) {
        ChronoUnit uu = (ChronoUnit)CALENDAR_UNITS.get(unit);
        if (null == uu) {
            throw new IllegalArgumentException("Rounding Unit not recognized: " + unit);
        }
        switch (1.$SwitchMap$java$time$temporal$ChronoUnit[uu.ordinal()]) {
            case 1: {
                return LocalDateTime.of(LocalDate.of(t.getYear(), 1, 1), LocalTime.MIDNIGHT);
            }
            case 2: {
                return LocalDateTime.of(LocalDate.of(t.getYear(), t.getMonth(), 1), LocalTime.MIDNIGHT);
            }
            case 3: {
                return LocalDateTime.of(t.toLocalDate(), LocalTime.MIDNIGHT);
            }
        }
        assert (!uu.isDateBased());
        return t.truncatedTo(uu);
    }

    private static Date parseNoMath(String val) {
        return new Date(PARSER.parse((CharSequence)val, Instant::from).toEpochMilli());
    }

    private DateMathParser() {
        this(null);
    }

    private DateMathParser(TimeZone tz) {
        this.zone = null != tz ? tz : DEFAULT_MATH_TZ;
    }

    private void setNow(Date n) {
        this.now = n;
    }

    private Date getNow() {
        if (this.now == null) {
            this.now = new Date();
        }
        return (Date)this.now.clone();
    }

    private Date parseMath(String math) throws ParseException {
        if (0 == math.length()) {
            return this.getNow();
        }
        ZoneId zoneId = UTC.toZoneId();
        LocalDateTime localDateTime = ZonedDateTime.ofInstant(this.getNow().toInstant(), zoneId).toLocalDateTime();
        String[] ops = splitter.split(math);
        int pos = 0;
        block10: while (pos < ops.length) {
            if (1 != ops[pos].length()) {
                throw new ParseException("Multi character command found: \"" + ops[pos] + "\"", pos);
            }
            char command = ops[pos++].charAt(0);
            switch (command) {
                case '/': {
                    if (ops.length < pos + 1) {
                        throw new ParseException("Need a unit after command: \"" + command + "\"", pos);
                    }
                    try {
                        localDateTime = DateMathParser.round((LocalDateTime)localDateTime, (String)ops[pos++]);
                        continue block10;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException("Unit not recognized: \"" + ops[pos - 1] + "\"", pos - 1);
                    }
                }
                case '+': 
                case '-': {
                    if (ops.length < pos + 2) {
                        throw new ParseException("Need a value and unit for command: \"" + command + "\"", pos);
                    }
                    int val = 0;
                    try {
                        val = Integer.parseInt(ops[pos++]);
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException("Not a Number: \"" + ops[pos - 1] + "\"", pos - 1);
                    }
                    if ('-' == command) {
                        val = 0 - val;
                    }
                    try {
                        String unit = ops[pos++];
                        localDateTime = DateMathParser.add((LocalDateTime)localDateTime, (int)val, (String)unit);
                        continue block10;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException("Unit not recognized: \"" + ops[pos - 1] + "\"", pos - 1);
                    }
                }
            }
            throw new ParseException("Unrecognized command: \"" + command + "\"", pos - 1);
        }
        return Date.from(ZonedDateTime.of(localDateTime, zoneId).toInstant());
    }

    static {
        DEFAULT_MATH_TZ = UTC = TimeZone.getTimeZone("UTC");
        PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendInstant().toFormatter(Locale.ROOT);
        CALENDAR_UNITS = DateMathParser.makeUnitsMap();
        splitter = Pattern.compile("\\b|(?<=\\d)(?=\\D)");
    }
}

