/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service;

import eu.europeana.api2.v2.model.json.view.submodel.HighlightHit;
import eu.europeana.api2.v2.model.json.view.submodel.HitSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class HitMaker {
    private static final Logger LOG = LogManager.getLogger(HitMaker.class);
    private static final Pattern FULLTEXT_PATTERN = Pattern.compile("fulltext\\.\\w{2,3}", 2);
    private static final String RDF_VALUE = "rdf:value";
    private static final String UNKNOWN = "unknown value";
    private static final String EM_START = "<em>";
    private static final String EM_END = "</em>";
    private static final String THE_END = "@end@";

    public List<HighlightHit> createHitList(Map<String, Map<String, List<String>>> highlighting, int nrSelectors) {
        ArrayList<HighlightHit> hitList = new ArrayList<HighlightHit>();
        for (Map.Entry<String, Map<String, List<String>>> hitParade : highlighting.entrySet()) {
            HighlightHit hit = new HighlightHit(hitParade.getKey());
            Map<String, List<String>> hitContent = hitParade.getValue();
            ArrayList selectors = new ArrayList();
            for (Map.Entry<String, List<String>> topOrFlop : hitContent.entrySet()) {
                this.findHits(topOrFlop, selectors, nrSelectors);
            }
            if (!CollectionUtils.isNotEmpty(selectors)) continue;
            hit.setSelectors(selectors);
            hitList.add(hit);
        }
        return hitList;
    }

    private void findHits(Map.Entry<String, List<String>> topOrFlop, List<HitSelector> selectors, int nrSelectors) {
        String keyString = HitMaker.getFieldString((String)topOrFlop.getKey());
        if (CollectionUtils.isNotEmpty((Collection)topOrFlop.getValue())) {
            int i = 1;
            for (String lyrics : topOrFlop.getValue()) {
                if (StringUtils.isNotBlank((CharSequence)lyrics)) {
                    do {
                        HitSelector selector;
                        if ((selector = this.createSelector(lyrics)) == null) {
                            LOG.error("Error: no highlighting could be retrieved for this element");
                            break;
                        }
                        selector.setField(keyString);
                        selectors.add(selector);
                        lyrics = selector.getRemainder();
                    } while (!StringUtils.equalsIgnoreCase((CharSequence)lyrics, (CharSequence)"@end@") && ++i <= nrSelectors);
                }
                if (i <= nrSelectors) continue;
                break;
            }
        }
    }

    private HitSelector createSelector(String lyrics) {
        String remainder;
        String suffix;
        String prefix = StringUtils.substringBefore((String)lyrics, (String)"<em>");
        lyrics = StringUtils.removeStart((String)StringUtils.removeStart((String)lyrics, (String)prefix), (String)"<em>");
        String exact = StringUtils.substringBefore((String)lyrics, (String)"</em>");
        lyrics = StringUtils.removeStart((String)StringUtils.removeStart((String)lyrics, (String)exact), (String)"</em>");
        while (lyrics.trim().startsWith("<em>")) {
            String spaces = StringUtils.substringBefore((String)lyrics, (String)"<em>");
            exact = exact + spaces;
            lyrics = StringUtils.removeStart((String)StringUtils.removeStart((String)lyrics, (String)spaces), (String)"<em>");
            String exact2 = StringUtils.substringBefore((String)lyrics, (String)"</em>");
            exact = exact + exact2;
            lyrics = StringUtils.removeStart((String)StringUtils.removeStart((String)lyrics, (String)exact2), (String)"</em>");
        }
        if (StringUtils.containsIgnoreCase((CharSequence)lyrics, (CharSequence)"<em>")) {
            suffix = StringUtils.substringBefore((String)lyrics, (String)"<em>");
            remainder = lyrics;
        } else {
            suffix = lyrics;
            remainder = "@end@";
        }
        if (prefix != null && exact != null && suffix != null && remainder != null) {
            return new HitSelector(prefix, exact, suffix, remainder);
        }
        return null;
    }

    private static String getFieldString(String keyValue) {
        Matcher matcher = FULLTEXT_PATTERN.matcher(keyValue);
        if (matcher.find()) {
            return "rdf:value";
        }
        return "unknown value";
    }
}

