/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.v2.model.NumericFacetParameter;
import eu.europeana.corelib.definitions.solr.SolrFacetType;
import eu.europeana.corelib.definitions.solr.TechnicalFacetType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FacetParameterUtils {
    static final String DEFAULT_LIMIT_KEY = "f.DEFAULT.facet.limit";
    static final String DEFAULT_OFFSET_KEY = "f.DEFAULT.facet.offset";
    public static final int LIMIT_FOR_DATA_PROVIDER = 50;
    static final int LIMIT_FOR_DEFAULT = 50;
    static final int LIMIT_FOR_CUSTOM = 50;
    static final int LIMIT_FOR_TECH_DEFAULT = 50;
    static final int LIMIT_FOR_TECH_CUSTOM = 50;
    private static List<String> defaultSolrFacetList;

    public static Map<String, Integer> getSolrFacetParams(String type, String[] solrFacets, Map<String, String[]> parameters, boolean defaultFacetsRequested) {
        HashMap<String, Integer> solrFacetParams = new HashMap<String, Integer>();
        if (defaultFacetsRequested) {
            for (SolrFacetType solrFacetType : SolrFacetType.values()) {
                FacetParameterUtils.saveFacetParam((String)type, (String)solrFacetType.name(), parameters, (boolean)true, (boolean)false, solrFacetParams);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])solrFacets)) {
            for (String string : solrFacets) {
                if (defaultFacetsRequested && defaultSolrFacetList.contains(string)) continue;
                FacetParameterUtils.saveFacetParam((String)type, (String)string, parameters, (boolean)defaultSolrFacetList.contains(string), (boolean)false, solrFacetParams);
            }
        }
        return solrFacetParams;
    }

    public static Map<String, Integer> getTechnicalFacetParams(String type, String[] technicalFacets, Map<String, String[]> parameters, boolean defaultFacetsRequested) {
        HashMap<String, Integer> technicalFacetParams;
        block3: {
            block2: {
                technicalFacetParams = new HashMap<String, Integer>();
                if (!defaultFacetsRequested) break block2;
                for (TechnicalFacetType technicalFacet : TechnicalFacetType.values()) {
                    FacetParameterUtils.saveFacetParam((String)type, (String)technicalFacet.name(), parameters, (boolean)true, (boolean)true, technicalFacetParams);
                }
                break block3;
            }
            if (!ArrayUtils.isNotEmpty((Object[])technicalFacets)) break block3;
            for (String technicalFacetName : technicalFacets) {
                FacetParameterUtils.saveFacetParam((String)type, (String)technicalFacetName, parameters, (boolean)false, (boolean)true, technicalFacetParams);
            }
        }
        return technicalFacetParams;
    }

    private static void saveFacetParam(String type, String name, Map<String, String[]> parameters, boolean isDefault, boolean isTech, Map<String, Integer> facetParams) {
        NumericFacetParameter parameter = null;
        if (type.equals("limit")) {
            parameter = FacetParameterUtils.getFacetLimit((String)name, parameters, (boolean)isDefault, (boolean)isTech);
        } else if (type.equals("offset")) {
            parameter = FacetParameterUtils.getFacetOffset((String)name, parameters, (boolean)isDefault);
        }
        if (parameter != null) {
            facetParams.put(parameter.getName(), parameter.getValue());
        }
    }

    private static NumericFacetParameter getFacetLimit(String facet, Map<String, String[]> parameters, boolean isDefault, boolean isTech) {
        String key = "f." + facet + ".facet.limit";
        Integer defaultLimit = isTech ? Integer.valueOf(isDefault ? 50 : 50) : Integer.valueOf(isDefault ? (StringUtils.equals((String)facet, (String)"DATA_PROVIDER") ? 50 : 50) : 50);
        return FacetParameterUtils.extractParameter((String)key, (String)"f.DEFAULT.facet.limit", parameters, (boolean)isDefault, (Integer)defaultLimit);
    }

    private static NumericFacetParameter getFacetOffset(String facet, Map<String, String[]> parameters, boolean isDefault) {
        String key = "f." + facet + ".facet.offset";
        return FacetParameterUtils.extractParameter((String)key, (String)"f.DEFAULT.facet.offset", parameters, (boolean)isDefault, null);
    }

    private static NumericFacetParameter extractParameter(String key, String defaultKey, Map<String, String[]> parameters, boolean isDefault, Integer defaultValue) {
        if (parameters.containsKey(key)) {
            String[] value = parameters.get(key);
            return new NumericFacetParameter(key, value[0]);
        }
        if (isDefault && parameters.containsKey(defaultKey)) {
            String[] value = parameters.get(defaultKey);
            return new NumericFacetParameter(key, value[0]);
        }
        if (defaultValue != null) {
            return new NumericFacetParameter(key, defaultValue);
        }
        return null;
    }

    public static String getLimitForDataProvider() {
        return String.valueOf(50);
    }

    static {
        if (defaultSolrFacetList == null) {
            defaultSolrFacetList = new ArrayList();
            for (SolrFacetType facet : SolrFacetType.values()) {
                defaultSolrFacetList.add(facet.toString());
            }
        }
    }
}

