/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.web.model.MediaFile;
import eu.europeana.corelib.web.service.MediaStorageService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class ThumbnailController {
    private static final Logger LOG = LogManager.getLogger(ThumbnailController.class);
    private static final String IIIF_HOST_NAME = "iiif.europeana.eu";
    @Resource(name="corelib_metisMediaStorageService")
    private MediaStorageService metisMediaStorage;
    @Resource(name="corelib_uimMediaStorageService")
    private MediaStorageService uimMediaStorage;

    @RequestMapping(value={"/v2/thumbnail-by-url.json"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> thumbnailByUrl(@RequestParam(value="uri", required=true) String url, @RequestParam(value="size", required=false, defaultValue="w400") String size, @RequestParam(value="type", required=false, defaultValue="IMAGE") String type, WebRequest webRequest, HttpServletResponse response) {
        ResponseEntity result;
        long startTime = 0L;
        if (LOG.isDebugEnabled()) {
            startTime = System.nanoTime();
            LOG.debug("Thumbnail url = {}, size = {}, type = {}", (Object)url, (Object)size, (Object)type);
        }
        MediaFile mediaFile = this.retrieveThumbnail(url, size);
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        HttpHeaders headers = new HttpHeaders();
        if (mediaFile == null) {
            headers.setContentType(MediaType.IMAGE_PNG);
            byte[] mediaContent = this.getDefaultThumbnailForNotFoundResourceByType(type);
            result = new ResponseEntity((Object)mediaContent, (MultiValueMap)headers, HttpStatus.OK);
        } else {
            headers.setContentType(this.getMediaType(url));
            byte[] mediaContent = mediaFile.getContent();
            result = new ResponseEntity((Object)mediaContent, (MultiValueMap)headers, HttpStatus.OK);
            if (mediaFile.getLastModified() != null && mediaFile.getETag() != null) {
                if (webRequest.checkNotModified(mediaFile.getETag(), mediaFile.getLastModified().getMillis())) {
                    result = null;
                }
            } else if (mediaFile.getETag() != null && webRequest.checkNotModified(mediaFile.getETag())) {
                result = null;
            }
        }
        if (LOG.isDebugEnabled()) {
            Long duration = (System.nanoTime() - startTime) / 1000L;
            if (MediaType.IMAGE_PNG.equals((Object)headers.getContentType())) {
                LOG.debug("Total thumbnail request time (missing media): {}", (Object)duration);
            } else if (result == null) {
                LOG.debug("Total thumbnail request time (from s3 + return 304): {}", (Object)duration);
            } else {
                LOG.debug("Total thumbnail request time (from s3 + return 200): {}", (Object)duration);
            }
        }
        return result;
    }

    private MediaFile retrieveThumbnail(String url, String size) {
        MediaFile mediaFile = null;
        String mediaFileId = this.computeResourceUrl(url, size);
        LOG.debug("id = {}", (Object)mediaFileId);
        mediaFile = this.metisMediaStorage.retrieveAsMediaFile(mediaFileId, url, Boolean.TRUE.booleanValue());
        LOG.debug("Metis thumbnail = {}", (Object)mediaFile);
        if (mediaFile == null) {
            mediaFile = this.uimMediaStorage.retrieveAsMediaFile(mediaFileId, url, Boolean.TRUE.booleanValue());
            LOG.debug("UIM thumbnail = {}", (Object)mediaFile);
        }
        if (mediaFile == null && ThumbnailController.isIiifRecordUrl((String)url)) {
            try {
                String width = StringUtils.equalsIgnoreCase((String)size, (String)"w200") ? "200" : "400";
                URI iiifUri = ThumbnailController.getIiifThumbnailUrl((String)url, (String)width);
                if (iiifUri != null) {
                    LOG.debug("IIIF url = {} ", (Object)iiifUri.getPath());
                    mediaFile = this.downloadImage(iiifUri);
                }
            }
            catch (URISyntaxException e) {
                LOG.error("Error reading IIIF thumbnail url", (Throwable)e);
            }
            catch (IOException io) {
                LOG.error("Error retrieving IIIF thumbnail image", (Throwable)io);
            }
        }
        return mediaFile;
    }

    private MediaType getMediaType(String url) {
        String urlLow = url.toLowerCase(Locale.GERMAN);
        if (urlLow.endsWith(".png") || urlLow.endsWith(".pdf")) {
            return MediaType.IMAGE_PNG;
        }
        return MediaType.IMAGE_JPEG;
    }

    protected static boolean isIiifRecordUrl(String url) {
        if (url != null) {
            String urlLowercase = url.toLowerCase(Locale.GERMAN);
            return urlLowercase.startsWith("http://iiif.europeana.eu") || urlLowercase.startsWith("https://iiif.europeana.eu");
        }
        return false;
    }

    protected static URI getIiifThumbnailUrl(String url, String width) throws URISyntaxException {
        if (ThumbnailController.isIiifRecordUrl((String)url)) {
            return new URI(url.replace("/full/full/0/default.", "/full/" + width + ",/0/default."));
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private MediaFile downloadImage(URI uri) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] getImage(String path) {
        byte[] result = null;
        try (InputStream in = this.getClass().getResourceAsStream(path);){
            result = IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            LOG.error("Error reading default thumbnail file", (Throwable)e);
        }
        return result;
    }

    private String getMD5(String resourceUrl) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(resourceUrl.getBytes(StandardCharsets.UTF_8));
            byte[] resultByte = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte aResultByte : resultByte) {
                sb.append(Integer.toString((aResultByte & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Error determining MD5 for resource {}", (Object)resourceUrl, (Object)e);
            return resourceUrl;
        }
    }

    private byte[] getDefaultThumbnailForNotFoundResourceByType(String type) {
        switch (StringUtils.upperCase((String)type)) {
            case "IMAGE": {
                return this.getImage("/images/EU_thumbnails_image.png");
            }
            case "SOUND": {
                return this.getImage("/images/EU_thumbnails_sound.png");
            }
            case "VIDEO": {
                return this.getImage("/images/EU_thumbnails_video.png");
            }
            case "TEXT": {
                return this.getImage("/images/EU_thumbnails_text.png");
            }
            case "3D": {
                return this.getImage("/images/EU_thumbnails_3d.png");
            }
        }
        return this.getImage("/images/EU_thumbnails_image.png");
    }

    private String computeResourceUrl(String resourceUrl, String resourceSize) {
        return this.getMD5(resourceUrl) + "-" + (StringUtils.equalsIgnoreCase((String)resourceSize, (String)"w200") ? "MEDIUM" : "LARGE");
    }
}

