/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpCacheUtils {
    private static final Logger LOG = LogManager.getLogger(HttpCacheUtils.class);
    public static final String IFNONEMATCH = "If-None-Match";
    public static final String IFMATCH = "If-Match";
    private static final String IFMODIFIEDSINCE = "If-Modified-Since";
    private static final String ANY = "\"*\"";
    private static String apiVersion;

    public String generateETag(String data, boolean weakETag, boolean includeApiVersion) {
        String eTag = "\"" + this.getSHA256Hash(data, includeApiVersion) + "\"";
        if (weakETag) {
            return "W/" + eTag;
        }
        return eTag;
    }

    private String getSHA256Hash(String data, boolean includeApiVersion) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
            if (includeApiVersion) {
                data = data + apiVersion;
            }
            byte[] encodedhash = digest.digest(data.getBytes(StandardCharsets.UTF_8));
            return HttpCacheUtils.bytesToHex((byte[])encodedhash);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Error creating SHA-265 hash", (Throwable)e);
            return null;
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private ZonedDateTime stringToZonedUTC(String dateString) {
        if (StringUtils.isEmpty((CharSequence)dateString)) {
            return null;
        }
        Date date = DateUtils.parseDate((String)dateString);
        if (date == null) {
            LOG.error("Error parsing request header Date string: " + dateString);
            return null;
        }
        return this.dateToZonedUTC(date);
    }

    private ZonedDateTime dateToZonedUTC(Date date) {
        return date.toInstant().atOffset(ZoneOffset.UTC).toZonedDateTime().withNano(0);
    }

    public String dateToRFC1123String(Date date) {
        return DateUtils.formatDate((Date)date);
    }

    private static String headerDateToString(ZonedDateTime lastModified) {
        return lastModified.format(DateTimeFormatter.RFC_1123_DATE_TIME);
    }

    public HttpServletResponse addDefaultHeaders(HttpServletResponse response, String eTag, String tsUpdated, String allow, String cacheControl) {
        if (StringUtils.isNotBlank((CharSequence)eTag)) {
            response.addHeader("ETag", eTag);
        }
        if (StringUtils.isNotBlank((CharSequence)tsUpdated)) {
            response.addHeader("Last-Modified", tsUpdated);
        }
        if (StringUtils.isNotBlank((CharSequence)allow)) {
            response.addHeader("Allow", allow);
        }
        if (StringUtils.isNotBlank((CharSequence)cacheControl)) {
            response.addHeader("Cache-Control", cacheControl);
        }
        return response;
    }

    public HttpServletResponse addCorsHeaders(HttpServletResponse response, String allowMethods, String allowHeaders, String exposeHeaders, String maxAge) {
        if (StringUtils.isNotBlank((CharSequence)allowMethods)) {
            response.addHeader("Access-Control-Allow-Methods", allowMethods);
        }
        if (StringUtils.isNotBlank((CharSequence)allowHeaders)) {
            response.addHeader("Access-Control-Allow-Headers", allowHeaders);
        }
        if (StringUtils.isNotBlank((CharSequence)exposeHeaders)) {
            response.addHeader("Access-Control-Expose-Headers", exposeHeaders);
        }
        if (StringUtils.isNotBlank((CharSequence)maxAge)) {
            response.addHeader("Access-Control-Max-Age", maxAge);
        }
        return response;
    }

    public boolean doesAnyIfNoneMatch(HttpServletRequest request, String eTag) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-None-Match")) && this.doesAnyETagMatch(request.getHeader("If-None-Match"), eTag);
    }

    public boolean isNotModifiedSince(HttpServletRequest request, Date tsUpdated) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-Modified-Since")) && Objects.requireNonNull(this.stringToZonedUTC(request.getHeader("If-Modified-Since"))).compareTo(this.dateToZonedUTC(tsUpdated)) >= 0;
    }

    @Deprecated
    public boolean isModifiedSince(HttpServletRequest request, Date tsUpdated) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-Modified-Since")) && Objects.requireNonNull(this.stringToZonedUTC(request.getHeader("If-Modified-Since"))).compareTo(this.dateToZonedUTC(tsUpdated)) < 0;
    }

    public boolean doesPreconditionFail(HttpServletRequest request, String eTag) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-Match")) && !this.doesAnyETagMatch(request.getHeader("If-Match"), eTag);
    }

    private boolean doesAnyETagMatch(String eTags, String eTagToMatch) {
        if (StringUtils.equals((CharSequence)"\"*\"", (CharSequence)eTags)) {
            return true;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{eTags, eTagToMatch})) {
            for (String eTag : StringUtils.stripAll((String[])StringUtils.split((String)eTags, (String)","))) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)eTag, (CharSequence)eTagToMatch)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        try (InputStream is = HttpCacheUtils.class.getClassLoader().getResourceAsStream("build.properties");){
            if (is == null) {
                LOG.warn("No build.properties file found.");
            } else {
                Properties buildProps = new Properties();
                buildProps.load(is);
                apiVersion = buildProps.getProperty("info.app.version");
            }
        }
        catch (IOException e) {
            LOG.warn("Error reading build.properties file", (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)apiVersion)) {
            LOG.warn("Unable to read API version from build.properties file, using current date instead");
            apiVersion = DateUtils.formatDate((Date)new Date());
        } else {
            LOG.info("API version = " + apiVersion);
        }
    }
}

