/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.http.HttpStatus;

public class ApiKeyUtils {
    private static final Logger LOG = Logger.getLogger(ApiKeyUtils.class);
    @Resource
    private ApiKeyService apiService;

    public LimitResponse checkLimit(String wskey, String url, RecordType recordType, String profile) throws ApiLimitException {
        ApiKey apiKey;
        long requestNumber = 0L;
        if (StringUtils.isBlank((CharSequence)wskey)) {
            throw new ApiLimitException(wskey, "No API key provided", 0L, HttpStatus.UNAUTHORIZED.value());
        }
        try {
            long t = System.currentTimeMillis();
            apiKey = (ApiKey)this.apiService.findByID((Serializable)((Object)wskey));
            if (apiKey == null) {
                throw new ApiLimitException(wskey, "Invalid API key", 0L, HttpStatus.UNAUTHORIZED.value());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Get apiKey took " + (System.currentTimeMillis() - t) + " ms"));
            }
            requestNumber = 999L;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting default request number; (checklimit disabled): " + requestNumber));
            }
        }
        catch (DatabaseException e) {
            LOG.error((Object)"Error retrieving apikey", (Throwable)e);
            ApiLimitException ex = new ApiLimitException(wskey, e.getMessage(), requestNumber, HttpStatus.UNAUTHORIZED.value());
            ex.initCause((Throwable)e);
            throw ex;
        }
        return new LimitResponse(apiKey, requestNumber);
    }
}

