/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.sugarcrm.SugarCRMSearchResults;
import eu.europeana.api2.v2.service.SugarCRMCache;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.db.entity.enums.RecordType;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Deprecated
public class SugarCRMController {
    private static final Logger LOG = LogManager.getLogger(SugarCRMController.class);
    @Resource
    private SugarCRMCache sugarCRMCache;
    @Resource
    private ApiKeyUtils apiKeyUtils;

    public ModelAndView findproviders(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="countryCode", required=false) String countryCode, @RequestParam(value="offset", required=false) String offset, @RequestParam(value="pagesize", required=false) String pagesize, HttpServletRequest request, HttpServletResponse httpResponse) throws ApiLimitException {
        SugarCRMSearchResults response;
        LimitResponse apiKeyCheck = this.apiKeyUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.PROVIDERS, null);
        ControllerUtils.addResponseHeaders((HttpServletResponse)httpResponse);
        Date starttime = new Date();
        try {
            int intOffset = offset == null ? 0 : Integer.parseInt(offset);
            int intPagesize = pagesize == null ? 0 : Integer.parseInt(pagesize);
            response = this.sugarCRMCache.getProviders(countryCode, intOffset, intPagesize);
            response = this.fillBasicResponse(response, wskey, apiKeyCheck, starttime);
        }
        catch (Exception e) {
            String error = "Error fetching all providers";
            LOG.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, error + " " + e.getMessage(), apiKeyCheck.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    private SugarCRMSearchResults fillBasicResponse(SugarCRMSearchResults<?> response, String wskey, LimitResponse apiKeyCheck, Date startTime) {
        response.apikey = wskey;
        response.requestNumber = apiKeyCheck.getRequestNumber();
        response.itemsCount = response.items.size();
        response.statsStartTime = startTime;
        response.statsDuration = new Date().getTime() - startTime.getTime();
        response.success = true;
        return response;
    }

    public ModelAndView findprovidersByID(@PathVariable String id, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse httpResponse) throws ApiLimitException {
        SugarCRMSearchResults response;
        LimitResponse apiKeyCheck = this.apiKeyUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.PROVIDER, null);
        ControllerUtils.addResponseHeaders((HttpServletResponse)httpResponse);
        Date starttime = new Date();
        try {
            response = this.sugarCRMCache.getProviderbyID(id);
            response = this.fillBasicResponse(response, wskey, apiKeyCheck, starttime);
            response.totalResults = response.items.size();
        }
        catch (Exception e) {
            String error = "Error fetching all providers";
            LOG.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, error + " " + e.getMessage(), apiKeyCheck.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    public ModelAndView findDatasetsPerProvider(@PathVariable String id, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse httpResponse) throws ApiLimitException {
        SugarCRMSearchResults response;
        LimitResponse apiKeyCheck = this.apiKeyUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.PROVIDER_DATASETS, null);
        ControllerUtils.addResponseHeaders((HttpServletResponse)httpResponse);
        Date starttime = new Date();
        try {
            response = this.sugarCRMCache.getCollectionByProviderID(id);
            response = this.fillBasicResponse(response, wskey, apiKeyCheck, starttime);
            response.totalResults = response.items.size();
        }
        catch (Exception e) {
            String error = "Error fetching datasets by provider id";
            LOG.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, error + " " + e.getMessage(), apiKeyCheck.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    public ModelAndView findDatasets(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="edmDatasetName", required=false) String name, @RequestParam(value="countryCode", required=false) String country, @RequestParam(value="status", required=false) String status, @RequestParam(value="offset", required=false) String offset, @RequestParam(value="pagesize", required=false) String pagesize, HttpServletRequest request, HttpServletResponse httpResponse) throws ApiLimitException {
        SugarCRMSearchResults response;
        LimitResponse apiKeyCheck = this.apiKeyUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.DATASETS, null);
        ControllerUtils.addResponseHeaders((HttpServletResponse)httpResponse);
        Date starttime = new Date();
        try {
            int intOffset = offset == null ? 0 : Integer.parseInt(offset);
            int intPagesize = pagesize == null ? 0 : Integer.parseInt(pagesize);
            response = this.sugarCRMCache.getCollections(intOffset, intPagesize, name, country, status);
            response = this.fillBasicResponse(response, wskey, apiKeyCheck, starttime);
        }
        catch (Exception e) {
            String error = "Error fetching all datasets";
            LOG.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, error + " " + e.getMessage(), apiKeyCheck.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    public ModelAndView findDatasetsById(@PathVariable String id, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse httpResponse) throws ApiLimitException {
        SugarCRMSearchResults response;
        LimitResponse apiKeyCheck = this.apiKeyUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.DATASETS, null);
        ControllerUtils.addResponseHeaders((HttpServletResponse)httpResponse);
        Date starttime = new Date();
        try {
            response = this.sugarCRMCache.getCollectionByID(id);
            response = this.fillBasicResponse(response, wskey, apiKeyCheck, starttime);
            response.totalResults = response.items.size();
        }
        catch (Exception e) {
            String error = "Error fetching datasets by dataset id";
            LOG.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, error + " " + e.getMessage(), apiKeyCheck.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }
}

