/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.utils;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersionUtils {
    private VersionUtils() {
    }

    public static String getVersion(Class clazz) {
        String result = clazz.getPackage().getImplementationVersion();
        if (result == null) {
            result = clazz.getPackage().getSpecificationVersion();
        }
        if (result == null) {
            result = VersionUtils.stripVersionFileName((String)clazz.getProtectionDomain().getCodeSource().getLocation().getPath());
        }
        return result;
    }

    public static FileTime getCreationDate(Class clazz) throws IOException, URISyntaxException {
        Path file = Paths.get(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
        BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        return attr.creationTime();
    }

    public static String convertToLocalTimeString(FileTime fileTime, ZoneId timezone) {
        if (fileTime != null) {
            LocalDateTime localTime = LocalDateTime.ofInstant(fileTime.toInstant(), timezone);
            StringBuilder timeString = new StringBuilder(localTime.toLocalDate().toString());
            timeString.append(' ').append(localTime.toLocalTime()).append(' ').append(timezone.getId());
            return timeString.toString();
        }
        return null;
    }

    private static String stripVersionFileName(String fileName) {
        Pattern pattern = Pattern.compile("[\\d][.][.\\d*]*(-SNAPSHOT)?");
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }
}

