/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import eu.europeana.api2.config.SwaggerConfig;
import eu.europeana.api2.utils.VersionUtils;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@PropertySource(value={"classpath:swagger.properties"})
public class SwaggerConfig {
    @Value(value="${api2.url}")
    private String apiUrl;
    @Value(value="${api2.canonical.url}")
    private String apiCanonicalUrl;

    @Bean
    public Docket customImplementation() {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.withClassAnnotation(SwaggerSelect.class)).apis(Predicates.not((Predicate)Predicates.or((Predicate)RequestHandlerSelectors.withMethodAnnotation(SwaggerIgnore.class), (Predicate)RequestHandlerSelectors.withClassAnnotation(SwaggerIgnore.class)))).build().host(this.getHostUrl()).pathProvider((PathProvider)new BasePathAwareRelativePathProvider(this, this.getApiPath())).apiInfo(this.apiInfo());
    }

    ApiInfo apiInfo() {
        String version = VersionUtils.getVersion(this.getClass());
        return new ApiInfo("Europeana REST API", "This Swagger API console provides an overview of an interface to the Europeana REST API. You can build and test anything from the simplest search to a complex query using facetList such as dates, geotags and permissions. For more help and information, head to our comprehensive <a href=\"http://labs.europeana.eu/api/\">online documentation</a>.", StringUtils.isNotEmpty((String)version) ? version : "version unknown", "http://www.europeana.eu/portal/en/rights.html", "http://labs.europeana.eu/api", "API terms of use", "http://www.europeana.eu/portal/en/rights/api.html");
    }

    private String getApiPath() {
        return "/" + (this.fullApiUrl().toLowerCase().contains("/api") ? "api" : "");
    }

    private String getHostUrl() {
        String hostUrl = this.fullApiUrl();
        return hostUrl.toLowerCase().contains("/api") ? hostUrl.substring(0, hostUrl.toLowerCase().indexOf("/api")) : hostUrl;
    }

    private String fullApiUrl() {
        return StringUtils.isNotBlank((String)this.apiUrl) ? this.apiUrl : (StringUtils.isNotBlank((String)this.apiCanonicalUrl) ? this.apiCanonicalUrl : "http://europeana.eu");
    }
}

