/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import eu.europeana.api2.v2.schedule.SugarCRMPollingScheduler;
import eu.europeana.api2.v2.service.SugarCRMCache;
import eu.europeana.api2.v2.service.SugarCRMImporter;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.features.ObjectStorageClient;
import eu.europeana.features.S3ObjectStorageClient;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@ImportResource(value={"classpath:corelib-db-context.xml", "classpath:corelib-solr-context.xml", "classpath:corelib-utils-context.xml", "classpath:corelib-web-context.xml", "classpath:spring-sugarcrmclient.xml"})
@EnableScheduling
@PropertySource(value={"classpath:europeana.properties"})
public class AppConfig {
    private static final Logger LOG = LogManager.getLogger(AppConfig.class);
    private static final String APP_NAME_IN_POSTGRES = "PostgreSQL JDBC Driver";
    private static final String QUERY_FILTER_STALE_SESSION = " AND state in ('idle', 'idle in transaction', 'idle in transaction (aborted)', 'disabled') AND current_timestamp - state_change > interval '5 minutes'";
    @Value(value="${s3.key}")
    private String key;
    @Value(value="${s3.secret}")
    private String secret;
    @Value(value="${s3.region}")
    private String region;
    @Value(value="${s3.bucket}")
    private String bucket;
    @Value(value="${postgres.max.stale.sessions:}")
    private Integer pgMaxStaleSessions;
    @Resource(name="corelib_db_dataSource")
    private DataSource postgres;
    @Autowired
    private Environment env;

    @PostConstruct
    public void logConfiguration() {
        LOG.info("CF_INSTANCE_GUID = {}, CF_INSTANCE_IP  = {}", (Object)System.getenv("CF_INSTANCE_GUID"), (Object)System.getenv("CF_INSTANCE_IP"));
        LOG.info("Active Spring profiles:" + Arrays.toString(this.env.getActiveProfiles()));
        LOG.info("Default Spring profiles:" + Arrays.toString(this.env.getDefaultProfiles()));
        try (Connection con = this.postgres.getConnection();){
            String dbUrl = con.getMetaData().getURL();
            if (dbUrl.contains("password")) {
                dbUrl = dbUrl.substring(0, dbUrl.indexOf("password"));
            }
            LOG.info("Connected to " + dbUrl);
        }
        catch (SQLException e) {
            LOG.error("Error checking database connection", (Throwable)e);
        }
        LOG.info("Default Postgres Datasource settings (or settings from CF environment):");
        LOG.info("  getAbandonWhenPercentageFull() = {}", (Object)this.postgres.getAbandonWhenPercentageFull());
        LOG.info("  getDefaultReadOnly = {}", (Object)this.postgres.getDefaultReadOnly());
        LOG.info("  getDefaultAutoCommit = {}", (Object)this.postgres.getDefaultAutoCommit());
        LOG.info("  getMaxAge = {}", (Object)this.postgres.getMaxAge());
        LOG.info("  getMaxWait = {}", (Object)this.postgres.getMaxWait());
        LOG.info("  getMinEvictableIdleTimeMillis() = {}", (Object)this.postgres.getMinEvictableIdleTimeMillis());
        LOG.info("  getNumTestsPerEvictionRun = {}", (Object)this.postgres.getNumTestsPerEvictionRun());
        LOG.info("  getTimeBetweenEvictionRunsMillis = {}", (Object)this.postgres.getTimeBetweenEvictionRunsMillis());
        LOG.info("Programmatically overriding settings:");
        this.postgres.setMinIdle(0);
        this.postgres.setMaxIdle(2);
        this.postgres.setMaxActive(10);
        LOG.info("  minIdle = {}, maxIdle = {}, maxActive = {} ", (Object)this.postgres.getMinIdle(), (Object)this.postgres.getMaxIdle(), (Object)this.postgres.getMaxActive());
        this.postgres.setTestOnBorrow(true);
        this.postgres.setValidationInterval(1000L);
        if (StringUtils.isEmpty((String)this.postgres.getValidationQuery())) {
            this.postgres.setValidationQuery("SELECT 1");
        }
        LOG.info("  isTestOnBorrow = {}, validationInterval = {}, validationQuery = {}, validationQueryTimeout = {}, logValidationError = {}", (Object)this.postgres.isTestOnBorrow(), (Object)this.postgres.getValidationInterval(), (Object)this.postgres.getValidationQuery(), (Object)this.postgres.getValidationQueryTimeout(), (Object)this.postgres.getLogValidationErrors());
        this.postgres.setRemoveAbandoned(true);
        this.postgres.setRemoveAbandonedTimeout(120);
        this.postgres.setLogAbandoned(true);
        LOG.info("  isRemoveAbandoned = {}, removeAbandonedTimeout = {}, logAbandoned = {} ", (Object)this.postgres.isRemoveAbandoned(), (Object)this.postgres.getRemoveAbandonedTimeout(), (Object)this.postgres.isLogAbandoned());
    }

    @Scheduled(fixedRate=60000L)
    public void debugJdbcThreadUsage() {
        long nrAbandoned = this.postgres.getRemoveAbandonedCount();
        long nrActive = this.postgres.getNumActive();
        long nrIdle = this.postgres.getIdle();
        Integer dbTotalSessions = this.getNrSessionsOnPostgresDb(false);
        Integer dbStaleSession = this.getNrSessionsOnPostgresDb(true);
        if (nrAbandoned == 0L && nrActive < 4L && dbStaleSession == 0) {
            LOG.info("Postgres threads: API idle = {}, active = {}, removeAbandoned = {} - PostgresDb totalSessions = {}, staleSessions = {})", (Object)nrIdle, (Object)nrActive, (Object)nrAbandoned, (Object)dbTotalSessions, (Object)dbStaleSession);
        } else {
            LOG.error("Postgres threads: API idle = {}, active = {}, removeAbandoned = {} - PostgresDb totalSessions = {}, staleSessions = {})", (Object)nrIdle, (Object)nrActive, (Object)nrAbandoned, (Object)dbTotalSessions, (Object)dbStaleSession);
        }
        if (this.pgMaxStaleSessions != null && dbStaleSession > this.pgMaxStaleSessions) {
            LOG.warn("{} stale postgres sessions terminated", (Object)this.removeHangingSessionOnPostgresDb());
        }
    }

    private Integer getNrSessionsOnPostgresDb(boolean staleOnly) {
        Integer result = null;
        String query = "SELECT count(pid) FROM pg_stat_activity WHERE application_name = ?";
        if (staleOnly) {
            query = query + QUERY_FILTER_STALE_SESSION;
        }
        try (Connection con = this.postgres.getConnection();
             PreparedStatement ps = con.prepareStatement(query);){
            ps.setString(1, APP_NAME_IN_POSTGRES);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                } else {
                    LOG.error("Postgres database didn't return session data");
                }
            }
        }
        catch (SQLException e) {
            LOG.error("Error checking number of sessions in postgres database", (Throwable)e);
        }
        return result;
    }

    private Integer removeHangingSessionOnPostgresDb() {
        Integer result = null;
        try (Connection con = this.postgres.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE application_name = ?  AND state in ('idle', 'idle in transaction', 'idle in transaction (aborted)', 'disabled') AND current_timestamp - state_change > interval '5 minutes'");){
            ps.setString(1, APP_NAME_IN_POSTGRES);
            try (ResultSet rs = ps.executeQuery();){
                result = 0;
                while (rs.next()) {
                    Integer n = result;
                    Integer n2 = result = Integer.valueOf(result + 1);
                }
            }
        }
        catch (SQLException e) {
            LOG.error("Error removing stale sessions in postgres database", (Throwable)e);
        }
        return result;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer properties() {
        PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer = new PropertySourcesPlaceholderConfigurer();
        propertySourcesPlaceholderConfigurer.setIgnoreResourceNotFound(true);
        propertySourcesPlaceholderConfigurer.setLocalOverride(true);
        propertySourcesPlaceholderConfigurer.setLocations(new org.springframework.core.io.Resource[]{new ClassPathResource("europeana.properties"), new ClassPathResource("europeana.user.properties")});
        return propertySourcesPlaceholderConfigurer;
    }

    @Bean
    public ApiKeyUtils apiKeyUtils() {
        return new ApiKeyUtils();
    }

    @Bean
    public SugarCRMPollingScheduler sugarCRMPollingScheduler() {
        return new SugarCRMPollingScheduler();
    }

    @Bean
    public SugarCRMImporter sugarCRMImporter() {
        return new SugarCRMImporter();
    }

    @Bean
    public SugarCRMCache sugarCRMCache() {
        return new SugarCRMCache();
    }

    @Bean(name={"api_object_storage_client"})
    public ObjectStorageClient objectStorageClient() {
        LOG.info("Creating new objectStorage client");
        return new S3ObjectStorageClient(this.key, this.secret, this.region, this.bucket);
    }
}

