/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.schedule;

import eu.europeana.api2.v2.service.SugarCRMImporter;
import eu.europeana.uim.sugarcrmclient.ws.exceptions.JIXBQueryResultException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;

public class SugarCRMPollingScheduler {
    private static final Logger LOG = LogManager.getLogger(SugarCRMPollingScheduler.class);
    @Resource
    private SugarCRMImporter sugarCRMImporter;
    private boolean firstRunComplete = false;

    @PostConstruct
    public void scheduleFirstRun() {
        try {
            this.sugarCRMImporter.populateRepositoryFromScratch();
        }
        catch (JIXBQueryResultException e) {
            LOG.error("Re-population of MongoDB Cache from SugarCRM failed: {}", (Object)e.getMessage(), (Object)e);
        }
        this.firstRunComplete = true;
    }

    @Scheduled(fixedRate=300000L)
    public void frequentUpdateTask() {
        if (this.firstRunComplete) {
            try {
                this.sugarCRMImporter.pollProviders();
                this.sugarCRMImporter.pollCollections();
            }
            catch (JIXBQueryResultException e) {
                LOG.error("Scheduled update for provider/collections failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

