/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.edm.exceptions.SolrTypeException;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.search.model.ResultSet;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class RedirectController {
    private static final Logger LOG = LogManager.getLogger(RedirectController.class);
    private SearchService searchService;

    @Autowired
    public RedirectController(SearchService searchService) {
        this.searchService = searchService;
    }

    @RequestMapping(value={"/{apiKey}/redirect", "/{apiKey}/redirect.json", "/v2/{apiKey}/redirect", "/v2/{apiKey}/redirect.json"}, method={RequestMethod.GET})
    public Object handleRedirect(@PathVariable String apiKey, @RequestParam(value="shownAt", required=true) String isShownAt, HttpServletResponse response) {
        if (StringUtils.isBlank((String)isShownAt)) {
            return this.generateError(response, "Empty 'shownAt' parameter", apiKey);
        }
        if (this.isInEuropeana(isShownAt)) {
            return "redirect:" + isShownAt;
        }
        return this.generateError(response, "Can't redirect: '" + isShownAt + "' is not a known 'shownAt' url", apiKey);
    }

    private ModelAndView generateError(HttpServletResponse response, String msg, String apiKey) {
        response.setStatus(400);
        LOG.error(msg);
        return JsonUtils.toJson((Object)new ApiError(apiKey, msg));
    }

    private boolean isInEuropeana(String encodedUrl) {
        try {
            String decodedUrl = URLDecoder.decode(encodedUrl, "UTF-8");
            Query query = new Query("provider_aggregation_edm_isShownAt:\"" + ClientUtils.escapeQueryChars((String)decodedUrl) + "\"").setApiQuery(true).setFacetsAllowed(false).setSpellcheckAllowed(false).setSort(null);
            ResultSet resultSet = this.searchService.search(BriefBean.class, query);
            return resultSet.getResultSize() > 0L;
        }
        catch (UnsupportedEncodingException uee) {
            LOG.error("Unsupported encoding", (Throwable)uee);
        }
        catch (SolrTypeException ste) {
            LOG.error("Error checking if url is in Solr index", (Throwable)ste);
        }
        return true;
    }
}

