/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import com.github.jsonldjava.core.JSONLD;
import com.github.jsonldjava.core.JSONLDProcessingError;
import com.github.jsonldjava.core.Options;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.impl.JenaRDFParser;
import com.github.jsonldjava.utils.JSONUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.model.xml.srw.SrwResponse;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.json.ObjectResult;
import eu.europeana.api2.v2.model.json.view.BriefView;
import eu.europeana.api2.v2.model.json.view.FullDoc;
import eu.europeana.api2.v2.model.json.view.FullView;
import eu.europeana.api2.v2.model.xml.srw.Record;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.api2.v2.web.controller.ObjectController;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.edm.exceptions.BadDataException;
import eu.europeana.corelib.edm.exceptions.MongoDBException;
import eu.europeana.corelib.edm.exceptions.MongoRuntimeException;
import eu.europeana.corelib.edm.utils.EdmUtils;
import eu.europeana.corelib.neo4j.exception.Neo4JException;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.web.exception.EuropeanaException;
import eu.europeana.corelib.web.utils.RequestUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Api(tags={"Record"})
@RequestMapping(value={"/v2/record"})
@SwaggerSelect
public class ObjectController {
    private static final Logger LOG = Logger.getLogger(ObjectController.class);
    private SearchService searchService;
    private ApiKeyUtils apiKeyUtils;

    @Autowired
    public ObjectController(SearchService searchService, ApiKeyUtils apiKeyUtils) {
        this.searchService = searchService;
        this.apiKeyUtils = apiKeyUtils;
    }

    @ApiOperation(value="get a single record in JSON format", nickname="getSingleRecordJson")
    @RequestMapping(value={"/{collectionId}/{recordId}.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView record(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="full") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="callback", required=false) String callback, WebRequest webRequest, HttpServletRequest servletRequest, HttpServletResponse response) throws ApiLimitException {
        RequestData data = new RequestData(collectionId, recordId, wskey, profile, callback, webRequest, servletRequest);
        try {
            return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT, data, response);
        }
        catch (EuropeanaException e) {
            LOG.error((Object)"Error retrieving record JSON", (Throwable)e);
            response.setStatus(500);
            return JsonUtils.toJson((Object)new ApiError(wskey, ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage(), data.apikeyCheckResponse.getRequestNumber()), (String)data.callback);
        }
    }

    @SwaggerIgnore
    @RequestMapping(value={"/context.jsonld", "/context.json-ld"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView contextJSONLD(@RequestParam(value="callback", required=false) String callback) {
        String jsonld = JSONUtils.toString((Object)this.getJsonContext());
        return JsonUtils.toJson((String)jsonld, (String)callback);
    }

    @SwaggerIgnore
    @RequestMapping(value={"/{collectionId}/{recordId}.json-ld"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView recordJSON_LD(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="format", required=false, defaultValue="compacted") String format, @RequestParam(value="callback", required=false) String callback, WebRequest webRequest, HttpServletRequest servletRequest, HttpServletResponse response) throws ApiLimitException {
        return this.recordJSONLD(collectionId, recordId, wskey, format, callback, webRequest, servletRequest, response);
    }

    @ApiOperation(value="get single record in JSON LD format", nickname="getSingleRecordJsonLD")
    @RequestMapping(value={"/{collectionId}/{recordId}.jsonld"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView recordJSONLD(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="format", required=false, defaultValue="compacted") String format, @RequestParam(value="callback", required=false) String callback, WebRequest webRequest, HttpServletRequest servletRequest, HttpServletResponse response) throws ApiLimitException {
        RequestData data = new RequestData(collectionId, recordId, wskey, format, callback, webRequest, servletRequest);
        try {
            return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_JSONLD, data, response);
        }
        catch (EuropeanaException e) {
            LOG.error((Object)"Error retrieving record JSON-LD", (Throwable)e);
            response.setStatus(500);
            return JsonUtils.toJson((Object)new ApiError(wskey, ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage(), data.apikeyCheckResponse.getRequestNumber()), (String)data.callback);
        }
    }

    @ApiOperation(value="get single record in RDF format)", nickname="getSingleRecordRDF")
    @RequestMapping(value={"/{collectionId}/{recordId}.rdf"}, method={RequestMethod.GET}, produces={"application/rdf+xml"})
    public ModelAndView recordRdf(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=true) String wskey, WebRequest webRequest, HttpServletRequest servletRequest, HttpServletResponse response) throws ApiLimitException {
        RequestData data = new RequestData(collectionId, recordId, wskey, null, null, webRequest, servletRequest);
        try {
            return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_RDF, data, response);
        }
        catch (EuropeanaException e) {
            LOG.error((Object)"Error retrieving record RDF", (Throwable)e);
            response.setStatus(500);
            return JsonUtils.toJson((Object)new ApiError(wskey, ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage(), data.apikeyCheckResponse.getRequestNumber()), (String)data.callback);
        }
    }

    @SwaggerIgnore
    @RequestMapping(value={"/{collectionId}/{recordId}.srw"}, method={RequestMethod.GET}, produces={"text/xml"})
    @ResponseBody
    public SrwResponse recordSrw(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=false) String wskey, WebRequest webRequest, HttpServletRequest servletRequest, HttpServletResponse response) throws ApiLimitException, EuropeanaException {
        RequestData data = new RequestData(collectionId, recordId, wskey, null, null, webRequest, servletRequest);
        Object out = this.handleRecordRequest(RecordType.OBJECT_SRW, data, response);
        if (out instanceof SrwResponse) {
            return (SrwResponse)out;
        }
        return null;
    }

    private Object handleRecordRequest(RecordType recordType, RequestData data, HttpServletResponse response) throws ApiLimitException, EuropeanaException {
        ModelAndView output;
        long startTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving record with id " + data.europeanaObjectId + ", type = " + recordType));
        }
        data.apikeyCheckResponse = this.apiKeyUtils.checkLimit(data.wskey, data.servletRequest.getRequestURL().toString(), recordType, data.profile);
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        FullBean bean = this.retrieveRecord(data.europeanaObjectId);
        if (bean == null) {
            String newId = this.findNewId(data.europeanaObjectId);
            if (newId != null) {
                bean = this.retrieveRecord(newId);
            }
            if (bean == null) {
                ModelAndView result;
                response.setStatus(404);
                if (recordType == RecordType.OBJECT_RDF) {
                    HashMap<String, String> model = new HashMap<String, String>();
                    model.put("error", "Non-existing record identifier");
                    result = new ModelAndView("rdf", model);
                } else {
                    result = recordType == RecordType.OBJECT_SRW ? null : JsonUtils.toJson((Object)new ApiError(data.wskey, "Invalid record identifier: " + data.europeanaObjectId, data.apikeyCheckResponse.getRequestNumber()), (String)data.callback);
                }
                return result;
            }
        }
        switch (1.$SwitchMap$eu$europeana$corelib$db$entity$enums$RecordType[recordType.ordinal()]) {
            case 1: {
                output = this.generateJson(bean, data, startTime);
                break;
            }
            case 2: {
                output = this.generateJsonLd(bean, data, response);
                break;
            }
            case 3: {
                output = this.generateRdf(bean);
                break;
            }
            case 4: {
                output = this.generateSrw(bean);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown record output type: " + recordType);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done generating record output in " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return output;
    }

    private ModelAndView generateJson(FullBean bean, RequestData data, long startTime) {
        ObjectResult objectResult = new ObjectResult(data.wskey, data.apikeyCheckResponse.getRequestNumber());
        if (StringUtils.containsIgnoreCase((String)data.profile, (String)"params")) {
            objectResult.addParams(RequestUtils.getParameterMap((HttpServletRequest)data.servletRequest), new String[]{"wskey"});
            objectResult.addParam("profile", (Object)data.profile);
        }
        objectResult.object = new FullView(bean, data.profile, data.wskey);
        objectResult.statsDuration = System.currentTimeMillis() - startTime;
        return JsonUtils.toJson((Object)objectResult, (String)data.callback);
    }

    private ModelAndView generateJsonLd(FullBean bean, RequestData data, HttpServletResponse response) {
        String jsonld = null;
        String rdf = EdmUtils.toEDM((FullBeanImpl)((FullBeanImpl)bean), (boolean)false);
        try (InputStream rdfInput = IOUtils.toInputStream((String)rdf);){
            Model modelResult = ModelFactory.createDefaultModel().read(rdfInput, "", "RDF/XML");
            Object raw = JSONLD.fromRDF((Object)modelResult, (RDFParser)new JenaRDFParser());
            if (StringUtils.equalsIgnoreCase((String)data.profile, (String)"compacted")) {
                raw = JSONLD.compact((Object)raw, (Object)this.getJsonContext(), (Options)new Options());
            } else if (StringUtils.equalsIgnoreCase((String)data.profile, (String)"flattened")) {
                raw = JSONLD.flatten((Object)raw);
            } else if (StringUtils.equalsIgnoreCase((String)data.profile, (String)"normalized")) {
                raw = JSONLD.normalize((Object)raw);
            }
            jsonld = JSONUtils.toString((Object)raw);
        }
        catch (JSONLDProcessingError | IOException e) {
            LOG.error((Object)"Error parsing JSON-LD data", e);
            response.setStatus(500);
            return JsonUtils.toJson((Object)new ApiError(data.wskey, e.getClass().getSimpleName() + ": " + e.getMessage()), (String)data.callback);
        }
        return JsonUtils.toJson((String)jsonld, (String)data.callback);
    }

    private ModelAndView generateRdf(FullBean bean) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("record", EdmUtils.toEDM((FullBeanImpl)((FullBeanImpl)bean), (boolean)false));
        return new ModelAndView("rdf", model);
    }

    private SrwResponse generateSrw(FullBean bean) {
        SrwResponse srwResponse = new SrwResponse();
        FullDoc doc = new FullDoc(bean);
        Record record = new Record();
        record.recordData.dc = doc;
        srwResponse.records.record.add(record);
        try {
            this.createXml(srwResponse);
        }
        catch (JAXBException e) {
            LOG.error((Object)"Error generating xml", (Throwable)e);
        }
        return srwResponse;
    }

    private FullBean retrieveRecord(String europeanaId) throws MongoRuntimeException, MongoDBException, Neo4JException {
        long startTime = System.currentTimeMillis();
        FullBean result = this.searchService.findById(europeanaId, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SearchService findByID took " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return result;
    }

    private String findNewId(String europeanaId) throws BadDataException {
        long startTime = System.currentTimeMillis();
        String newId = this.searchService.resolveId(europeanaId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SearchService find newId took " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return newId;
    }

    private String generateRedirectUrl(HttpServletRequest req, String oldId, String newId) {
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        String requestUri = req.getRequestURI();
        String pathInfo = req.getPathInfo();
        String queryString = req.getQueryString();
        if (!(requestUri = requestUri.replace(oldId, newId)).contains(newId)) {
            throw new IllegalStateException("Error generating record redirect url");
        }
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(':').append(serverPort);
        }
        url.append(requestUri);
        if (pathInfo != null) {
            url.append(pathInfo);
        }
        if (queryString != null) {
            url.append('?').append(queryString);
        }
        return url.toString();
    }

    @Deprecated
    private List<BriefView> getSimilarItems(String europeanaId, String wskey) {
        ArrayList<BriefView> result = new ArrayList<BriefView>();
        try {
            long startTime = System.currentTimeMillis();
            List similarItems = this.searchService.findMoreLikeThis(europeanaId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SearchService find similar items took " + (System.currentTimeMillis() - startTime) + " ms"));
            }
            for (BriefBean b : similarItems) {
                String similarItemsProfile = "minimal";
                BriefView view = new BriefView(b, similarItemsProfile, wskey);
                result.add(view);
            }
        }
        catch (SolrServerException e) {
            LOG.error((Object)("Error retrieving similar items: " + e.getLocalizedMessage()), (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getJsonContext() {
        try (InputStream in = this.getClass().getResourceAsStream("/jsonld/context.jsonld");){
            Object object = JSONUtils.fromInputStream((InputStream)in);
            return object;
        }
        catch (IOException e) {
            LOG.error((Object)"Error reading context.jsonld", (Throwable)e);
            return null;
        }
    }

    private void createXml(SrwResponse response) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SrwResponse.class});
        Marshaller marshaller = context.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)response, (Writer)stringWriter);
    }
}

