/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import com.google.common.base.Throwables;
import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.utils.ControllerUtils;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class ExceptionControllerAdvice {
    private static final Logger LOG = LogManager.getLogger(ExceptionControllerAdvice.class);

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ModelAndView missingParameterErrorHandler(HttpServletRequest request, HttpServletResponse response, MissingServletRequestParameterException ex) {
        ModelAndView result;
        String errorMsg;
        response.setStatus(400);
        String requestFormat = ControllerUtils.getRequestFormat((HttpServletRequest)request);
        if ("wskey".equalsIgnoreCase(ex.getParameterName())) {
            response.setStatus(401);
            errorMsg = "No API key provided";
        } else {
            errorMsg = "Required parameter '" + ex.getParameterName() + "' missing";
        }
        if ("RDF".equalsIgnoreCase(requestFormat)) {
            result = this.generateRdfError(errorMsg);
        } else {
            if ("SRW".equalsIgnoreCase(requestFormat)) {
                return null;
            }
            result = JsonUtils.toJson((Object)new ApiError("", errorMsg));
        }
        return result;
    }

    @ExceptionHandler(value={ApiLimitException.class})
    public ModelAndView apiLimitErrorHandler(HttpServletRequest request, HttpServletResponse response, ApiLimitException e) throws ApiLimitException {
        response.setStatus(e.getHttpStatus());
        String requestFormat = ControllerUtils.getRequestFormat((HttpServletRequest)request);
        if ("RDF".equalsIgnoreCase(requestFormat)) {
            return this.generateRdfError("Unregistered API key");
        }
        if ("SRW".equalsIgnoreCase(requestFormat)) {
            return null;
        }
        return JsonUtils.toJson((Object)new ApiError(e), (String)request.getParameter("callback"));
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView defaultExceptionHandler(HttpServletRequest request, HttpServletResponse response, Exception e) throws Exception {
        LOG.error("Caught exception: {}, {}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
        LOG.error("Stacktrace: {}", (Object)Throwables.getStackTraceAsString((Throwable)e));
        response.setStatus(500);
        String requestFormat = ControllerUtils.getRequestFormat((HttpServletRequest)request);
        if ("RDF".equalsIgnoreCase(requestFormat)) {
            return this.generateRdfError("Internal server error");
        }
        if ("SRW".equalsIgnoreCase(requestFormat)) {
            throw e;
        }
        String wskey = request.getParameter("wskey");
        String callback = request.getParameter("callback");
        return JsonUtils.toJson((Object)new ApiError(wskey, e.getClass().getSimpleName() + ": " + e.getMessage()), (String)callback);
    }

    private ModelAndView generateRdfError(String errorMessage) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("error", errorMessage);
        return new ModelAndView("rdf", model);
    }
}

