/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.utils.VersionUtils;
import eu.europeana.api2.v2.model.VersionInfoResult;
import eu.europeana.corelib.search.SearchService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VersionController {
    private static final Logger LOG = Logger.getLogger(VersionController.class);

    @RequestMapping(value={"version", "/v2/version"}, method={RequestMethod.GET})
    public VersionInfoResult getVersion() {
        VersionInfoResult result = new VersionInfoResult();
        try {
            result.setApiBuildInfo(VersionUtils.getVersion(VersionInfoResult.class) + " " + VersionUtils.getCreationDate(VersionInfoResult.class));
            result.setCorelibBuildInfo(VersionUtils.getVersion(SearchService.class) + " " + VersionUtils.getCreationDate(SearchService.class));
        }
        catch (IOException | URISyntaxException e) {
            LOG.warn((Object)"Error retrieving api or corelib build information", (Throwable)e);
        }
        InputStream is = this.getClass().getResourceAsStream("/../../build.txt");
        if (is == null) {
            LOG.warn((Object)"No api2 build.txt file found!");
        } else {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append(' ');
                }
                result.setApiBuildInfo(sb.toString());
            }
            catch (IOException e) {
                LOG.error((Object)"Error reading API2 build.txt file", (Throwable)e);
            }
        }
        return result;
    }
}

