/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.domain.MediaFile;
import eu.europeana.corelib.web.service.MediaStorageService;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
public class ThumbnailController {
    private static final Logger LOG = Logger.getLogger(ThumbnailController.class);
    private MediaStorageService mediaStorageService;

    @Autowired
    private ThumbnailController(MediaStorageService mediaStorageService) {
        this.mediaStorageService = mediaStorageService;
    }

    @RequestMapping(value={"/v2/thumbnail-by-url.json"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> thumbnailByUrl(@RequestParam(value="uri", required=false) String url, @RequestParam(value="size", required=false, defaultValue="FULL_DOC") String size, @RequestParam(value="type", required=false, defaultValue="IMAGE") String type, WebRequest webRequest, HttpServletResponse response) throws IOException {
        long startTime = 0L;
        if (LOG.isDebugEnabled()) {
            startTime = System.nanoTime();
        }
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        HttpHeaders headers = new HttpHeaders();
        String mediaFileId = this.computeResourceUrl(url, size);
        ResponseEntity result = null;
        MediaFile mediaFile = this.mediaStorageService.retrieve(mediaFileId, Boolean.TRUE);
        if (mediaFile == null) {
            headers.setContentType(MediaType.IMAGE_PNG);
            byte[] mediaContent = this.getDefaultThumbnailForNotFoundResourceByType(type);
            result = new ResponseEntity((Object)mediaContent, (MultiValueMap)headers, HttpStatus.OK);
        } else if (!webRequest.checkNotModified(mediaFile.getContentMd5(), mediaFile.getCreatedAt().getMillis())) {
            headers.setContentType(MediaType.IMAGE_JPEG);
            byte[] mediaContent = mediaFile.getContent();
            result = new ResponseEntity((Object)mediaContent, (MultiValueMap)headers, HttpStatus.OK);
        }
        if (LOG.isDebugEnabled()) {
            Long duration = (System.nanoTime() - startTime) / 1000L;
            if (MediaType.IMAGE_PNG.equals((Object)headers.getContentType())) {
                LOG.debug((Object)("Total thumbnail request time (missing media): " + duration));
            } else if (result == null) {
                LOG.debug((Object)("Total thumbnail request time (from s3 + return 304): " + duration));
            } else {
                LOG.debug((Object)("Total thumbnail request time (from s3 + return 200): " + duration));
            }
        }
        return result;
    }

    private byte[] getImage(String path) {
        byte[] result = null;
        try (InputStream in = this.getClass().getResourceAsStream(path);){
            result = IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            LOG.error((Object)"Error reading default thumbnail file", (Throwable)e);
        }
        return result;
    }

    private String getMD5(String resourceUrl, String input) {
        String temp;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(input.getBytes("UTF-8"));
            byte[] resultByte = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte aResultByte : resultByte) {
                sb.append(Integer.toString((aResultByte & 0xFF) + 256, 16).substring(1));
            }
            temp = sb.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            LOG.error((Object)("Error determining MD5 for resource " + resourceUrl), (Throwable)e);
            temp = input;
        }
        return temp;
    }

    private byte[] getDefaultThumbnailForNotFoundResourceByType(String type) {
        switch (StringUtils.upperCase((String)type)) {
            case "IMAGE": {
                return this.getImage("/images/EU_thumbnails_image.png");
            }
            case "SOUND": {
                return this.getImage("/images/EU_thumbnails_sound.png");
            }
            case "VIDEO": {
                return this.getImage("/images/EU_thumbnails_video.png");
            }
            case "TEXT": {
                return this.getImage("/images/EU_thumbnails_text.png");
            }
            case "3D": {
                return this.getImage("/images/EU_thumbnails_3d.png");
            }
        }
        return this.getImage("/images/EU_thumbnails_image.png");
    }

    private String computeResourceUrl(String resourceUrl, String resourceSize) {
        String urlText = resourceUrl == null ? "" : resourceUrl;
        return this.getMD5(resourceUrl, urlText) + "-" + (StringUtils.equalsIgnoreCase((String)resourceSize, (String)"w200") ? "MEDIUM" : "LARGE");
    }
}

