/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.FieldTripUtils;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.utils.XmlUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.SearchResults;
import eu.europeana.api2.v2.model.json.Suggestions;
import eu.europeana.api2.v2.model.json.view.ApiView;
import eu.europeana.api2.v2.model.json.view.BriefView;
import eu.europeana.api2.v2.model.json.view.RichView;
import eu.europeana.api2.v2.model.xml.kml.KmlResponse;
import eu.europeana.api2.v2.model.xml.rss.Channel;
import eu.europeana.api2.v2.model.xml.rss.Item;
import eu.europeana.api2.v2.model.xml.rss.RssResponse;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripChannel;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripImage;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripItem;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripResponse;
import eu.europeana.api2.v2.service.FacetWrangler;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.api2.v2.utils.FacetParameterUtils;
import eu.europeana.api2.v2.utils.ModelUtils;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.exception.LimitReachedException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.edm.beans.ApiBean;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.beans.RichBean;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.edm.exceptions.SolrTypeException;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.search.model.ResultSet;
import eu.europeana.corelib.search.utils.SearchUtils;
import eu.europeana.corelib.solr.bean.impl.ApiBeanImpl;
import eu.europeana.corelib.solr.bean.impl.BriefBeanImpl;
import eu.europeana.corelib.solr.bean.impl.IdBeanImpl;
import eu.europeana.corelib.solr.bean.impl.RichBeanImpl;
import eu.europeana.corelib.utils.StringArrayUtils;
import eu.europeana.corelib.web.exception.ProblemType;
import eu.europeana.corelib.web.model.rights.RightReusabilityCategorizer;
import eu.europeana.corelib.web.service.EuropeanaUrlService;
import eu.europeana.corelib.web.support.Configuration;
import eu.europeana.corelib.web.utils.NavigationUtils;
import eu.europeana.corelib.web.utils.RequestUtils;
import eu.europeana.crf_faketags.extractor.CommonTagExtractor;
import eu.europeana.crf_faketags.utils.FakeTagsUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@SwaggerSelect
@Api(tags={"Search"}, description=" ")
public class SearchController {
    private Logger log = Logger.getLogger(SearchController.class);
    @Resource
    private SearchService searchService;
    @Resource
    private ApiKeyService apiService;
    @Resource
    private Configuration configuration;
    @Resource
    private EuropeanaUrlService urlService;
    @Resource
    private ApiKeyUtils apiKeyUtils;
    @Resource(name="api2_mvc_xmlUtils")
    private XmlUtils xmlUtils;

    @ApiOperation(value="search for records", nickname="searchRecords", response=Void.class)
    @RequestMapping(value={"/v2/search.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView searchJson(@RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="query", required=true) String queryString, @RequestParam(value="qf", required=false) String[] refinementArray, @RequestParam(value="reusability", required=false) String[] reusabilityArray, @RequestParam(value="profile", required=false, defaultValue="standard") String profile, @RequestParam(value="start", required=false, defaultValue="1") int start, @RequestParam(value="rows", required=false, defaultValue="12") int rows, @RequestParam(value="facet", required=false) String[] mixedFacetArray, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="colourpalette", required=false) String[] colourPaletteArray, @RequestParam(value="thumbnail", required=false) Boolean thumbnail, @RequestParam(value="media", required=false) Boolean media, @RequestParam(value="text_fulltext", required=false) Boolean fullText, @RequestParam(value="landingpage", required=false) Boolean landingPage, @RequestParam(value="cursor", required=false) String cursorMark, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) throws ApiLimitException {
        LimitResponse limitResponse = this.apiKeyUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.SEARCH, profile);
        if (StringUtils.isBlank((String)queryString)) {
            response.setStatus(400);
            return JsonUtils.toJson((Object)new ApiError("", "Empty query parameter"), (String)callback);
        }
        queryString = queryString.trim();
        queryString = queryString.replace(":https://", ":http://");
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("QUERY: |" + queryString + "|"));
        }
        if (cursorMark != null && start > 1) {
            response.setStatus(400);
            return JsonUtils.toJson((Object)new ApiError("", "Parameters 'start' and 'cursorMark' cannot be used together"), (String)callback);
        }
        String[] _qf = (String[])request.getParameterMap().get("qf");
        if (_qf != null && _qf.length != refinementArray.length) {
            refinementArray = _qf;
        }
        if (sort != null && (sort.equalsIgnoreCase("timestamp") || sort.toLowerCase().startsWith("timestamp "))) {
            sort = "";
        }
        ArrayList colourPalette = new ArrayList();
        if (ArrayUtils.isNotEmpty((Object[])colourPaletteArray)) {
            StringArrayUtils.addToList(colourPalette, (String[])colourPaletteArray);
        }
        colourPalette.replaceAll(String::toUpperCase);
        String colourPalettefilterQuery = "";
        Boolean hasImageRefinements = false;
        Boolean hasSoundRefinements = false;
        Boolean hasVideoRefinements = false;
        ArrayList<String> newRefinements = new ArrayList<String>();
        ArrayList<String> imageMimeTypeRefinements = new ArrayList<String>();
        ArrayList<String> soundMimeTypeRefinements = new ArrayList<String>();
        ArrayList<String> videoMimeTypeRefinements = new ArrayList<String>();
        ArrayList<String> otherMimeTypeRefinements = new ArrayList<String>();
        ArrayList<String> imageSizeRefinements = new ArrayList<String>();
        ArrayList<String> imageAspectRatioRefinements = new ArrayList<String>();
        ArrayList<String> soundDurationRefinements = new ArrayList<String>();
        ArrayList<String> videoDurationRefinements = new ArrayList<String>();
        ArrayList<String> imageColourSpaceRefinements = new ArrayList<String>();
        ArrayList<String> videoHDRefinements = new ArrayList<String>();
        ArrayList<String> soundHQRefinements = new ArrayList<String>();
        ArrayList<String> imageColourPaletteRefinements = new ArrayList<String>();
        if (refinementArray != null) {
            block35: for (String qf : refinementArray) {
                if (StringUtils.contains((String)qf, (String)":")) {
                    String refinementValue = StringUtils.substringAfter((String)qf, (String)":").toLowerCase();
                    switch (StringUtils.substringBefore((String)qf, (String)":")) {
                        case "MIME_TYPE": {
                            if (CommonTagExtractor.isImageMimeType((String)refinementValue)) {
                                imageMimeTypeRefinements.add(refinementValue);
                                hasImageRefinements = true;
                                break;
                            }
                            if (CommonTagExtractor.isSoundMimeType((String)refinementValue)) {
                                soundMimeTypeRefinements.add(refinementValue);
                                hasSoundRefinements = true;
                                break;
                            }
                            if (CommonTagExtractor.isVideoMimeType((String)refinementValue)) {
                                videoMimeTypeRefinements.add(refinementValue);
                                hasVideoRefinements = true;
                                break;
                            }
                            otherMimeTypeRefinements.add(refinementValue);
                            break;
                        }
                        case "IMAGE_SIZE": {
                            imageSizeRefinements.add(refinementValue);
                            hasImageRefinements = true;
                            break;
                        }
                        case "IMAGE_COLOUR": 
                        case "IMAGE_COLOR": {
                            if (Boolean.valueOf(refinementValue).booleanValue()) {
                                imageColourSpaceRefinements.add("rgb");
                                hasImageRefinements = true;
                                break;
                            }
                            if (!StringUtils.equalsIgnoreCase((String)refinementValue, (String)"false")) continue block35;
                            imageColourSpaceRefinements.add("grayscale");
                            hasImageRefinements = true;
                            break;
                        }
                        case "COLOURPALETTE": 
                        case "COLORPALETTE": {
                            imageColourPaletteRefinements.add(refinementValue.toUpperCase());
                            hasImageRefinements = true;
                            break;
                        }
                        case "IMAGE_ASPECTRATIO": {
                            imageAspectRatioRefinements.add(refinementValue);
                            hasImageRefinements = true;
                            break;
                        }
                        case "SOUND_HQ": {
                            soundHQRefinements.add(Boolean.valueOf(refinementValue) != false ? "true" : "false");
                            hasSoundRefinements = true;
                            break;
                        }
                        case "SOUND_DURATION": {
                            soundDurationRefinements.add(refinementValue);
                            hasSoundRefinements = true;
                            break;
                        }
                        case "VIDEO_HD": {
                            videoHDRefinements.add(Boolean.valueOf(refinementValue) != false ? "true" : "false");
                            hasVideoRefinements = true;
                            break;
                        }
                        case "VIDEO_DURATION": {
                            videoDurationRefinements.add(refinementValue);
                            hasVideoRefinements = true;
                            break;
                        }
                        case "MEDIA": {
                            if (null != media) continue block35;
                            media = Boolean.valueOf(refinementValue);
                            break;
                        }
                        case "THUMBNAIL": {
                            if (null != thumbnail) continue block35;
                            thumbnail = Boolean.valueOf(refinementValue);
                            break;
                        }
                        case "TEXT_FULLTEXT": {
                            if (null != fullText) continue block35;
                            fullText = Boolean.valueOf(refinementValue);
                            break;
                        }
                        case "LANDINGPAGE": {
                            if (null != landingPage) continue block35;
                            landingPage = Boolean.valueOf(refinementValue);
                            break;
                        }
                        default: {
                            newRefinements.add(qf);
                            break;
                        }
                    }
                    continue;
                }
                newRefinements.add(qf);
            }
        }
        if (null != media) {
            newRefinements.add("has_media:" + media.toString());
        }
        if (null != thumbnail) {
            newRefinements.add("has_thumbnails:" + thumbnail.toString());
        }
        if (null != fullText) {
            newRefinements.add("is_fulltext:" + fullText.toString());
        }
        if (null != landingPage) {
            newRefinements.add("has_landingpage:" + landingPage.toString());
        }
        refinementArray = newRefinements.toArray(new String[newRefinements.size()]);
        if (!colourPalette.isEmpty()) {
            Iterator it = FakeTagsUtils.colourPaletteFilterTags(colourPalette).iterator();
            if (it.hasNext()) {
                colourPalettefilterQuery = "filter_tags:" + ((Integer)it.next()).toString();
            }
            while (it.hasNext()) {
                colourPalettefilterQuery = colourPalettefilterQuery + " AND filter_tags:" + ((Integer)it.next()).toString();
            }
            queryString = queryString + (StringUtils.isNotBlank((String)queryString) ? " AND " + colourPalettefilterQuery : colourPalettefilterQuery);
        }
        ArrayList filterTags = new ArrayList();
        if (hasImageRefinements.booleanValue()) {
            filterTags.addAll(FakeTagsUtils.imageFilterTags(imageMimeTypeRefinements, imageSizeRefinements, imageColourSpaceRefinements, imageAspectRatioRefinements, imageColourPaletteRefinements));
        }
        if (hasSoundRefinements.booleanValue()) {
            filterTags.addAll(FakeTagsUtils.soundFilterTags(soundMimeTypeRefinements, soundHQRefinements, soundDurationRefinements));
        }
        if (hasVideoRefinements.booleanValue()) {
            filterTags.addAll(FakeTagsUtils.videoFilterTags(videoMimeTypeRefinements, videoHDRefinements, videoDurationRefinements));
        }
        if (otherMimeTypeRefinements.size() > 0) {
            filterTags.addAll(FakeTagsUtils.otherFilterTags(otherMimeTypeRefinements));
        }
        String filterTagQuery = "";
        if (!filterTags.isEmpty()) {
            Iterator it = filterTags.iterator();
            if (it.hasNext()) {
                filterTagQuery = "filter_tags:" + ((Integer)it.next()).toString();
            }
            while (it.hasNext()) {
                filterTagQuery = filterTagQuery + " OR filter_tags:" + ((Integer)it.next()).toString();
            }
            queryString = queryString + (StringUtils.isNotBlank((String)queryString) ? " AND (" + filterTagQuery + ")" : filterTagQuery);
        }
        Object[] reusabilities = StringArrayUtils.splitWebParameter((String[])reusabilityArray);
        Object[] mixedFacets = StringArrayUtils.splitWebParameter((String[])mixedFacetArray);
        boolean facetsRequested = StringUtils.containsIgnoreCase((String)profile, (String)"portal") || StringUtils.containsIgnoreCase((String)profile, (String)"facets");
        boolean defaultFacetsRequested = facetsRequested && (ArrayUtils.isEmpty((Object[])mixedFacets) || ArrayUtils.contains((Object[])mixedFacets, (Object)"DEFAULT"));
        boolean defaultOrReusabilityFacetsRequested = defaultFacetsRequested || facetsRequested && ArrayUtils.contains((Object[])mixedFacets, (Object)"REUSABILITY");
        Map separatedFacets = ModelUtils.separateAndLimitFacets((String[])mixedFacets, (boolean)defaultFacetsRequested);
        Object[] solrFacets = (String[])ArrayUtils.addAll((Object[])((Object[])separatedFacets.get("solrfacets")), (Object[])((Object[])separatedFacets.get("customfacets")));
        String[] technicalFacets = (String[])separatedFacets.get("technicalfacets");
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        rows = Math.min(rows, this.configuration.getApiRowLimit());
        Map valueReplacements = new HashMap();
        if (ArrayUtils.isNotEmpty((Object[])reusabilities)) {
            valueReplacements = RightReusabilityCategorizer.mapValueReplacements((String[])reusabilities, (boolean)true);
            refinementArray = (String[])ArrayUtils.addAll((Object[])refinementArray, (Object[])valueReplacements.keySet().toArray(new String[valueReplacements.keySet().size()]));
        }
        Class clazz = this.selectBean(profile);
        Query query = new Query(SearchUtils.rewriteQueryFields((String)SearchUtils.fixBuggySolrIndex((String)queryString))).setApiQuery(true).setRefinements(refinementArray).setPageSize(rows).setStart(start - 1).setSort(sort).setCurrentCursorMark(cursorMark).setParameter("facet.mincount", "1").setParameter("fl", IdBeanImpl.getFields((Class)this.getBeanImpl(clazz))).setSpellcheckAllowed(false);
        if (facetsRequested) {
            Map parameterMap = request.getParameterMap();
            query.setSolrFacets((String[])solrFacets).setDefaultFacetsRequested(defaultFacetsRequested).convertAndSetSolrParameters(FacetParameterUtils.getSolrFacetParams((String)"limit", (String[])solrFacets, (Map)parameterMap, (boolean)defaultFacetsRequested)).convertAndSetSolrParameters(FacetParameterUtils.getSolrFacetParams((String)"offset", (String[])solrFacets, (Map)parameterMap, (boolean)defaultFacetsRequested)).setTechnicalFacets(technicalFacets).setTechnicalFacetLimits(FacetParameterUtils.getTechnicalFacetParams((String)"limit", (String[])technicalFacets, (Map)parameterMap, (boolean)defaultFacetsRequested)).setTechnicalFacetOffsets(FacetParameterUtils.getTechnicalFacetParams((String)"offset", (String[])technicalFacets, (Map)parameterMap, (boolean)defaultFacetsRequested)).setFacetsAllowed(true);
        } else {
            query.setFacetsAllowed(false);
        }
        query.setValueReplacements(valueReplacements);
        if (defaultOrReusabilityFacetsRequested) {
            query.setQueryFacets(RightReusabilityCategorizer.getQueryFacets());
        }
        if (StringUtils.containsIgnoreCase((String)profile, (String)"portal") || StringUtils.containsIgnoreCase((String)profile, (String)"spelling")) {
            query.setSpellcheckAllowed(true);
        }
        if (facetsRequested && !query.hasParameter("f.DATA_PROVIDER.facet.limit") && (ArrayUtils.contains((Object[])solrFacets, (Object)"DATA_PROVIDER") || ArrayUtils.contains((Object[])solrFacets, (Object)"DEFAULT"))) {
            query.setParameter("f.DATA_PROVIDER.facet.limit", String.valueOf(50));
        }
        try {
            SearchResults result = this.createResults(wskey, profile, query, clazz);
            result.requestNumber = limitResponse.getRequestNumber();
            if (StringUtils.containsIgnoreCase((String)profile, (String)"params")) {
                result.addParams(RequestUtils.getParameterMap((HttpServletRequest)request), new String[]{"wskey"});
                result.addParam("profile", (Object)profile);
                result.addParam("start", (Object)start);
                result.addParam("rows", (Object)rows);
                result.addParam("sort", (Object)sort);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("got response " + result.items.size()));
            }
            return JsonUtils.toJson((Object)result, (String)callback);
        }
        catch (SolrTypeException e) {
            if (e.getProblem().equals((Object)ProblemType.SEARCH_LIMIT_REACHED)) {
                this.log.error((Object)(wskey + " [search.json] " + ProblemType.SEARCH_LIMIT_REACHED.getMessage()));
            } else {
                this.log.error((Object)(wskey + " [search.json] "), (Throwable)e);
            }
            response.setStatus(400);
            return JsonUtils.toJson((Object)new ApiError(wskey, e.getMessage()), (String)callback);
        }
        catch (Exception e) {
            this.log.error((Object)(wskey + " [search.json] " + e.getClass().getSimpleName()), (Throwable)e);
            response.setStatus(400);
            return JsonUtils.toJson((Object)new ApiError(wskey, e.getMessage()), (String)callback);
        }
    }

    private Class<? extends IdBean> selectBean(String profile) {
        Class clazz = StringUtils.containsIgnoreCase((String)profile, (String)"minimal") ? BriefBean.class : (StringUtils.containsIgnoreCase((String)profile, (String)"rich") ? RichBean.class : ApiBean.class);
        return clazz;
    }

    private Class<? extends IdBeanImpl> getBeanImpl(Class clazz) {
        if (BriefBean.class.equals((Object)clazz)) {
            return BriefBeanImpl.class;
        }
        if (RichBean.class.equals((Object)clazz)) {
            return RichBeanImpl.class;
        }
        return ApiBeanImpl.class;
    }

    @ApiOperation(value="get autocompletion recommendations for search queries", nickname="suggestions")
    @RequestMapping(value={"/v2/suggestions.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView suggestionsJson(@RequestParam(value="query", required=true) String query, @RequestParam(value="rows", required=false, defaultValue="10") int count, @RequestParam(value="phrases", required=false, defaultValue="false") boolean phrases, @RequestParam(value="callback", required=false) String callback, HttpServletResponse response) {
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("phrases: " + phrases));
        }
        Suggestions apiResponse = new Suggestions(null);
        try {
            apiResponse.items = this.searchService.suggestions(query, count);
            apiResponse.itemsCount = apiResponse.items.size();
        }
        catch (SolrTypeException e) {
            return JsonUtils.toJson((Object)new ApiError(null, e.getMessage()), (String)callback);
        }
        return JsonUtils.toJson((Object)apiResponse, (String)callback);
    }

    private <T extends IdBean> SearchResults<T> createResults(String apiKey, String profile, Query query, Class<T> clazz) throws SolrTypeException {
        List allQueryFacetsMap;
        FacetWrangler wrangler = new FacetWrangler();
        SearchResults response = new SearchResults(apiKey);
        ResultSet resultSet = StringUtils.containsIgnoreCase((String)profile, (String)"debug") ? this.searchService.search(clazz, query, true) : this.searchService.search(clazz, query);
        response.totalResults = resultSet.getResultSize();
        if (StringUtils.isNotBlank((String)resultSet.getCurrentCursorMark()) && StringUtils.isNotBlank((String)resultSet.getNextCursorMark()) && !resultSet.getNextCursorMark().equalsIgnoreCase(resultSet.getCurrentCursorMark())) {
            response.nextCursor = resultSet.getNextCursorMark();
        }
        response.itemsCount = resultSet.getResults().size();
        response.items = resultSet.getResults();
        ArrayList<Object> beans = new ArrayList<Object>();
        for (IdBean b : resultSet.getResults()) {
            if (b instanceof RichBean) {
                beans.add(new RichView((RichBean)b, profile, apiKey));
                continue;
            }
            if (b instanceof ApiBean) {
                beans.add(new ApiView((ApiBean)b, profile, apiKey));
                continue;
            }
            if (!(b instanceof BriefBean)) continue;
            beans.add(new BriefView((BriefBean)b, profile, apiKey));
        }
        List facetFields = resultSet.getFacetFields();
        if (resultSet.getQueryFacets() != null && !(allQueryFacetsMap = SearchUtils.extractQueryFacets((Map)resultSet.getQueryFacets())).isEmpty()) {
            facetFields.addAll(allQueryFacetsMap);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("beans: " + beans.size()));
        }
        response.items = beans;
        if (StringUtils.containsIgnoreCase((String)profile, (String)"facets") || StringUtils.containsIgnoreCase((String)profile, (String)"portal")) {
            response.facets = wrangler.consolidateFacetList(resultSet.getFacetFields(), query.getTechnicalFacets(), query.isDefaultFacetsRequested(), query.getTechnicalFacetLimits(), query.getTechnicalFacetOffsets());
        }
        if (StringUtils.containsIgnoreCase((String)profile, (String)"breadcrumb") || StringUtils.containsIgnoreCase((String)profile, (String)"portal")) {
            response.breadCrumbs = NavigationUtils.createBreadCrumbList((Query)query);
        }
        if (StringUtils.containsIgnoreCase((String)profile, (String)"spelling") || StringUtils.containsIgnoreCase((String)profile, (String)"portal")) {
            response.spellcheck = ModelUtils.convertSpellCheck((SpellCheckResponse)resultSet.getSpellcheck());
        }
        if (StringUtils.containsIgnoreCase((String)profile, (String)"debug")) {
            response.debug = resultSet.getSolrQueryString();
        }
        return response;
    }

    @SwaggerIgnore
    @RequestMapping(value={"/v2/search.kml"}, method={RequestMethod.GET}, produces={"application/vnd.google-earth.kml+xml", "application/xml", "application/xhtml+xml"})
    @ResponseBody
    public KmlResponse searchKml(@RequestParam(value="query", required=true) String queryString, @RequestParam(value="qf", required=false) String[] refinementArray, @RequestParam(value="start", required=false, defaultValue="1") int start, @RequestParam(value="wskey", required=true) String wskey, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] _qf = (String[])request.getParameterMap().get("qf");
        if (_qf != null && _qf.length != refinementArray.length) {
            refinementArray = _qf;
        }
        try {
            ApiKey apiKey = (ApiKey)this.apiService.findByID((Serializable)((Object)wskey));
            this.apiService.checkReachedLimit(apiKey);
        }
        catch (DatabaseException e) {
            response.setStatus(401);
            throw new Exception(e);
        }
        catch (LimitReachedException e) {
            response.setStatus(429);
            throw new Exception(e);
        }
        KmlResponse kmlResponse = new KmlResponse();
        Query query = new Query(SearchUtils.rewriteQueryFields((String)queryString)).setRefinements(refinementArray).setApiQuery(true).setSpellcheckAllowed(false).setFacetsAllowed(false);
        query.setRefinements(new String[]{"pl_wgs84_pos_lat_long:[* TO *]"});
        try {
            ResultSet resultSet = this.searchService.search(BriefBean.class, query);
            kmlResponse.document.extendedData.totalResults.value = Long.toString(resultSet.getResultSize());
            kmlResponse.document.extendedData.startIndex.value = Integer.toString(start);
            kmlResponse.setItems(resultSet.getResults());
        }
        catch (SolrTypeException e) {
            response.setStatus(500);
            throw new Exception(e);
        }
        return kmlResponse;
    }

    @ApiOperation(value="basic search function following the OpenSearch specification", nickname="openSearch")
    @RequestMapping(value={"/v2/opensearch.rss"}, method={RequestMethod.GET}, produces={"application/rss+xml", "application/xml", "application/xhtml+xml"})
    @ResponseBody
    public RssResponse openSearchRss(@RequestParam(value="searchTerms", required=true) String queryString, @RequestParam(value="startIndex", required=false, defaultValue="1") int start, @RequestParam(value="count", required=false, defaultValue="12") int count) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("openSearch query with terms: " + queryString));
        }
        RssResponse rss = new RssResponse();
        Channel channel = rss.channel;
        channel.startIndex.value = start;
        channel.itemsPerPage.value = count;
        channel.query.searchTerms = queryString;
        channel.query.startPage = start;
        try {
            Query query = new Query(SearchUtils.rewriteQueryFields((String)queryString)).setApiQuery(true).setPageSize(count).setStart(start - 1).setFacetsAllowed(false).setSpellcheckAllowed(false);
            ResultSet resultSet = this.searchService.search(BriefBean.class, query);
            channel.totalResults.value = resultSet.getResultSize();
            for (BriefBean bean : resultSet.getResults()) {
                Item item = new Item();
                item.guid = this.urlService.getPortalRecord(false, bean.getId()).toString();
                item.title = this.getTitle(bean);
                item.description = this.getDescription(bean);
                item.link = item.guid;
                channel.items.add(item);
            }
        }
        catch (SolrTypeException e) {
            this.log.error((Object)"Error executing opensearch query", (Throwable)e);
            channel.totalResults.value = 0L;
            Item item = new Item();
            item.title = "Error";
            item.description = e.getMessage();
            channel.items.add(item);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Returning rss result: " + rss));
        }
        return rss;
    }

    @ApiOperation(value="Google Fieldtrip formatted RSS of selected collections", nickname="fieldTrip")
    @RequestMapping(value={"/v2/search.rss"}, method={RequestMethod.GET}, produces={"application/xml", "*/*"})
    public ModelAndView fieldTripRss(@RequestParam(value="query", required=true) String queryTerms, @RequestParam(value="offset", required=false, defaultValue="1") int offset, @RequestParam(value="limit", required=false, defaultValue="12") int limit, @RequestParam(value="profile", required=false, defaultValue="FieldTrip") String profile, @RequestParam(value="language", required=false) String reqLanguage, HttpServletResponse response) {
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        FieldTripResponse rss = new FieldTripResponse();
        FieldTripChannel channel = rss.channel;
        FieldTripUtils fieldTripUtils = new FieldTripUtils(this.urlService);
        if (queryTerms == null || "".equalsIgnoreCase(queryTerms) || "".equals(this.getIdFromQueryTerms(queryTerms))) {
            response.setStatus(400);
            String errorMsg = "error: Query ('" + queryTerms + "') is malformed, can't retrieve collection ID";
            this.log.error((Object)errorMsg);
            FieldTripItem item = new FieldTripItem();
            item.title = "Error";
            item.description = errorMsg;
            channel.items.add(item);
        } else {
            String collectionID = this.getIdFromQueryTerms(queryTerms);
            Map gftChannelAttributes = this.configuration.getGftChannelAttributes(collectionID);
            if (gftChannelAttributes.isEmpty() || gftChannelAttributes.size() < 5) {
                this.log.error((Object)"error: one or more attributes are not defined in europeana.properties for [INSERT COLLECTION ID HERE]");
                channel.title = "error retrieving attributes";
                channel.description = "error retrieving attributes";
                channel.language = "--";
                channel.link = "error retrieving attributes";
                channel.image = null;
            } else {
                String string = gftChannelAttributes.get(reqLanguage + "_title") == null || ((String)gftChannelAttributes.get(reqLanguage + "_title")).equalsIgnoreCase("") ? (gftChannelAttributes.get("title") == null || ((String)gftChannelAttributes.get("title")).equalsIgnoreCase("") ? "no title defined" : (String)gftChannelAttributes.get("title")) : (channel.title = (String)gftChannelAttributes.get(reqLanguage + "_title"));
                channel.description = gftChannelAttributes.get(reqLanguage + "_description") == null || ((String)gftChannelAttributes.get(reqLanguage + "_description")).equalsIgnoreCase("") ? (gftChannelAttributes.get("description") == null || ((String)gftChannelAttributes.get("description")).equalsIgnoreCase("") ? "no description defined" : (String)gftChannelAttributes.get("description")) : (String)gftChannelAttributes.get(reqLanguage + "_description");
                channel.language = gftChannelAttributes.get("language") == null || ((String)gftChannelAttributes.get("language")).equalsIgnoreCase("") ? "--" : (String)gftChannelAttributes.get("language");
                channel.link = gftChannelAttributes.get("link") == null || ((String)gftChannelAttributes.get("link")).equalsIgnoreCase("") ? "no link defined" : (String)gftChannelAttributes.get("link");
                FieldTripImage fieldTripImage = channel.image = gftChannelAttributes.get("image") == null || ((String)gftChannelAttributes.get("image")).equalsIgnoreCase("") ? null : new FieldTripImage((String)gftChannelAttributes.get("image"));
            }
            if (StringUtils.equals((String)profile, (String)"FieldTrip")) {
                ++offset;
            }
            try {
                Query query = new Query(SearchUtils.rewriteQueryFields((String)queryTerms)).setApiQuery(true).setPageSize(limit).setStart(offset - 1).setFacetsAllowed(false).setSpellcheckAllowed(false);
                ResultSet resultSet = this.searchService.search(RichBean.class, query);
                for (RichBean bean : resultSet.getResults()) {
                    if (reqLanguage != null && !this.getDcLanguage((BriefBean)bean).equalsIgnoreCase(reqLanguage)) continue;
                    channel.items.add(fieldTripUtils.createItem(bean));
                }
            }
            catch (SolrTypeException | MissingResourceException e) {
                this.log.error((Object)("error: " + e.getLocalizedMessage()));
                FieldTripItem item = new FieldTripItem();
                item.title = "Error";
                item.description = e.getMessage();
                channel.items.add(item);
            }
        }
        String xml = fieldTripUtils.cleanRss(this.xmlUtils.toString((Object)rss));
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("rss", xml);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/xml");
        return new ModelAndView("rss", model);
    }

    private String getTitle(BriefBean bean) {
        if (!ArrayUtils.isEmpty((Object[])bean.getTitle())) {
            for (String title : bean.getTitle()) {
                if (StringUtils.isBlank((String)title)) continue;
                return title;
            }
        }
        return bean.getDataProvider()[0] + " " + bean.getId();
    }

    private String getDescription(BriefBean bean) {
        StringBuilder sb = new StringBuilder();
        if (bean.getDcCreator() != null && bean.getDcCreator().length > 0 && StringUtils.isNotBlank((String)bean.getDcCreator()[0])) {
            sb.append(bean.getDcCreator()[0]);
        }
        if (bean.getYear() != null && bean.getYear().length > 0) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(StringUtils.join((Object[])bean.getYear(), (String)", "));
        }
        if (!ArrayUtils.isEmpty((Object[])bean.getProvider())) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(StringUtils.join((Object[])bean.getProvider(), (String)", "));
        }
        return sb.toString();
    }

    private String getDcLanguage(BriefBean bean) {
        if (bean.getDcLanguage() != null && bean.getDcLanguage().length > 0 && StringUtils.isNotBlank((String)bean.getDcLanguage()[0])) {
            return bean.getDcLanguage()[0];
        }
        return "";
    }

    private String getIdFromQueryTerms(String queryTerms) {
        return queryTerms.substring(queryTerms.indexOf(":"), queryTerms.indexOf("*")).replaceAll("\\D+", "");
    }
}

