/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.service.HierarchyRunner;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.search.SearchService;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/v2/record"})
public class HierarchicalController {
    private static Logger log = Logger.getLogger(HierarchicalController.class);
    @Resource
    private SearchService searchService;
    private static final int DEFAULT_HIERARCHY_TIMEOUT = 8000;
    private static final int MAX_HIERARCHY_TIMEOUT = 20000;
    private static final int MIN_HIERARCHY_TIMEOUT = 400;
    @Resource
    private ApiKeyUtils apiKeyUtils;

    @Bean
    public HierarchyRunner hierarchyRunnerBean() {
        return new HierarchyRunner();
    }

    @ApiOperation(value="returns the object itself")
    @RequestMapping(value={"/{collectionId}/{recordId}/self.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getSelf(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="hierarchytimeout", required=false, defaultValue="0") int hierarchyTimeout, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttrs) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_SELF, collectionId, recordId, profile, wskey, -1, -1, callback, request, response, redirectAttrs, hierarchyTimeout);
    }

    @ApiOperation(value="returns the object, its ancestors and siblings")
    @RequestMapping(value={"/{collectionId}/{recordId}/ancestor-self-siblings.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getAncestorSelfSiblings(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="hierarchytimeout", required=false, defaultValue="0") int hierarchyTimeout, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttrs) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_ANCESTOR_SELF_SIBLINGS, collectionId, recordId, profile, wskey, -1, -1, callback, request, response, redirectAttrs, hierarchyTimeout);
    }

    @ApiOperation(value="returns the object's children")
    @RequestMapping(value={"/{collectionId}/{recordId}/children.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getChildren(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="hierarchytimeout", required=false, defaultValue="0") int hierarchyTimeout, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttrs) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_CHILDREN, collectionId, recordId, profile, wskey, limit, offset, callback, request, response, redirectAttrs, hierarchyTimeout);
    }

    @ApiOperation(value="returns the object's parent")
    @RequestMapping(value={"/{collectionId}/{recordId}/parent.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getParent(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="hierarchytimeout", required=false, defaultValue="0") int hierarchyTimeout, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttrs) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_PARENT, collectionId, recordId, profile, wskey, limit, offset, callback, request, response, redirectAttrs, hierarchyTimeout);
    }

    @ApiOperation(value="returns the object's preceding siblings")
    @RequestMapping(value={"/{collectionId}/{recordId}/preceding-siblings.json", "/{collectionId}/{recordId}/preceeding-siblings.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getPrecedingSiblings(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="hierarchytimeout", required=false, defaultValue="0") int hierarchyTimeout, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttrs) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_PRECEDING_SIBLINGS, collectionId, recordId, profile, wskey, limit, offset, callback, request, response, redirectAttrs, hierarchyTimeout);
    }

    @ApiOperation(value="returns the object's following siblings")
    @RequestMapping(value={"/{collectionId}/{recordId}/following-siblings.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getFollowingSiblings(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="hierarchytimeout", required=false, defaultValue="0") int hierarchyTimeout, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttrs) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_FOLLOWING_SIBLINGS, collectionId, recordId, profile, wskey, limit, offset, callback, request, response, redirectAttrs, hierarchyTimeout);
    }

    public ModelAndView hierarchyTemplate(RecordType recordType, String collectionId, String recordId, String profile, String wskey, int limit, int offset, String callback, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttrs, int hierarchyTimeout) {
        String rdfAbout = "/" + collectionId + "/" + recordId;
        HierarchyRunner mrBean = this.hierarchyRunnerBean();
        hierarchyTimeout = hierarchyTimeout == 0 ? 8000 : (hierarchyTimeout < 400 ? 400 : (hierarchyTimeout > 20000 ? 20000 : hierarchyTimeout));
        try {
            ExecutorService timeoutExecutorService = Executors.newSingleThreadExecutor();
            Future<ModelAndView> myFlexibleFriend = timeoutExecutorService.submit(() -> mrBean.call(recordType, rdfAbout, profile, wskey, limit, offset, callback, request, response, log, this.apiKeyUtils, this.searchService));
            return myFlexibleFriend.get(hierarchyTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            response.setStatus(504);
            log.error((Object)("InterruptedException thrown: " + e.getMessage()));
            if (null != e.getCause()) {
                log.error((Object)("Cause: " + e.getCause().toString()));
            }
            return this.generateErrorHierarchy(rdfAbout, wskey, callback, "InterruptedException thrown when processing");
        }
        catch (TimeoutException e) {
            response.setStatus(504);
            log.error((Object)("TimeoutException thrown: " + e.getMessage()));
            if (null != e.getCause()) {
                log.error((Object)("Cause: " + e.getCause().toString()));
            }
            return this.generateErrorHierarchy(rdfAbout, wskey, callback, "TimeoutException thrown when processing");
        }
        catch (ExecutionException e) {
            log.error((Object)("ExecutionExeption thrown: " + e.getMessage()));
            if (null != e.getCause()) {
                log.error((Object)("Cause: " + e.getCause().toString()));
            }
            ModelAndView gimmeJustTheRecordThen = new ModelAndView("redirect:/v2/record" + rdfAbout + ".json");
            redirectAttrs.addAttribute("profile", (Object)profile);
            redirectAttrs.addAttribute("wskey", (Object)wskey);
            redirectAttrs.addAttribute("callback", (Object)callback);
            return gimmeJustTheRecordThen;
        }
    }

    private ModelAndView generateErrorHierarchy(String rdfAbout, String wskey, String callback, String message) {
        return JsonUtils.toJson((Object)new ApiError(wskey, String.format(message + " record %s", rdfAbout), 999L), (String)callback);
    }
}

