/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service;

import eu.europeana.api2.v2.model.json.common.LabelFrequency;
import eu.europeana.api2.v2.model.json.view.submodel.Facet;
import eu.europeana.api2.v2.utils.ModelUtils;
import eu.europeana.corelib.definitions.solr.SolrFacetType;
import eu.europeana.corelib.definitions.solr.TechnicalFacetType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.FacetField;

public class FacetWrangler {
    private static Logger log = Logger.getLogger(FacetWrangler.class);
    private Map<TechnicalFacetType, Map<String, Integer>> technicalFacetMap = new HashMap();

    public FacetWrangler() {
        for (TechnicalFacetType technicalFacet : TechnicalFacetType.values()) {
            this.technicalFacetMap.put(technicalFacet, new LinkedHashMap());
        }
    }

    public List<Facet> consolidateFacetList(List<FacetField> facetFields, List<String> requestedTechnicalFacets, boolean defaultFacetsRequested, Map<String, Integer> technicalFacetLimits, Map<String, Integer> technicalFacetOffsets) {
        if (facetFields == null || facetFields.isEmpty()) {
            return null;
        }
        ArrayList<Facet> facetList = new ArrayList<Facet>();
        for (FacetField facetField : facetFields) {
            if (facetField.getValues() == null) continue;
            Facet facet = new Facet();
            facet.name = facetField.getName();
            if (StringUtils.equalsIgnoreCase((String)SolrFacetType.TEXT_FULLTEXT.toString(), (String)facet.name)) {
                facet.name = SolrFacetType.TEXT_FULLTEXT.name();
            } else if (StringUtils.equalsIgnoreCase((String)SolrFacetType.MEDIA.toString(), (String)facet.name)) {
                facet.name = SolrFacetType.MEDIA.name();
            } else if (StringUtils.equalsIgnoreCase((String)SolrFacetType.THUMBNAIL.toString(), (String)facet.name)) {
                facet.name = SolrFacetType.THUMBNAIL.name();
            } else if (StringUtils.equalsIgnoreCase((String)SolrFacetType.LANDINGPAGE.toString(), (String)facet.name)) {
                facet.name = SolrFacetType.LANDINGPAGE.name();
            }
            if (facetField.getName().equalsIgnoreCase("facet_tags")) {
                for (FacetField.Count encodedTechnicalFacet : facetField.getValues()) {
                    TechnicalFacetType technicalFacetName;
                    String decodedTechnicalFacetName;
                    if (!StringUtils.isNotEmpty((String)encodedTechnicalFacet.getName()) || encodedTechnicalFacet.getCount() <= 0L || (decodedTechnicalFacetName = ModelUtils.decodeFacetTag((Integer)Integer.valueOf(encodedTechnicalFacet.getName()), (boolean)true)).isEmpty()) continue;
                    try {
                        technicalFacetName = TechnicalFacetType.valueOf((String)decodedTechnicalFacetName);
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)("error matching decoded technical facet name " + decodedTechnicalFacetName + " with enum type in [consolidateFacetList] " + e.getClass().getSimpleName()), (Throwable)e);
                        continue;
                    }
                    String technicalFacetLabel = ModelUtils.decodeFacetTag((Integer)Integer.valueOf(encodedTechnicalFacet.getName()), (boolean)false);
                    if (technicalFacetLabel.isEmpty()) continue;
                    Integer technicalFacetFieldCount = (Integer)((Map)this.technicalFacetMap.get(technicalFacetName)).get(technicalFacetLabel);
                    if (null == technicalFacetFieldCount) {
                        technicalFacetFieldCount = 0;
                    }
                    ((Map)this.technicalFacetMap.get(technicalFacetName)).put(technicalFacetLabel, technicalFacetFieldCount + (int)encodedTechnicalFacet.getCount());
                }
                continue;
            }
            for (FacetField.Count count : facetField.getValues()) {
                if (!StringUtils.isNotEmpty((String)count.getName()) || count.getCount() <= 0L) continue;
                LabelFrequency facetValue = new LabelFrequency();
                facetValue.count = count.getCount();
                facetValue.label = count.getName();
                facet.fields.add(facetValue);
            }
            if (facet.fields.isEmpty()) continue;
            facetList.add(facet);
        }
        if (null != requestedTechnicalFacets && !requestedTechnicalFacets.isEmpty()) {
            for (String requestedFacetName : requestedTechnicalFacets) {
                TechnicalFacetType matchedFacetName;
                try {
                    matchedFacetName = TechnicalFacetType.valueOf((String)requestedFacetName);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("error matching requested technical facet name " + requestedFacetName + " with enum type in [consolidateFacetList] " + e.getClass().getSimpleName()), (Throwable)e);
                    continue;
                }
                String facetLimit = "f." + matchedFacetName + ".facet.limit";
                String facetOffset = "f." + matchedFacetName + ".facet.offset";
                if (((Map)this.technicalFacetMap.get(matchedFacetName)).isEmpty()) continue;
                int from = Math.min(null != technicalFacetOffsets && technicalFacetOffsets.containsKey(facetOffset) ? technicalFacetOffsets.get(facetOffset) : 0, ((Map)this.technicalFacetMap.get(matchedFacetName)).size() - 1);
                int to = Math.min(null != technicalFacetLimits && technicalFacetLimits.containsKey(facetLimit) ? technicalFacetLimits.get(facetLimit) + from : ((Map)this.technicalFacetMap.get(matchedFacetName)).size(), ((Map)this.technicalFacetMap.get(matchedFacetName)).size());
                Facet facet = new Facet();
                facet.name = matchedFacetName.getRealName();
                if (null != requestedTechnicalFacets && !requestedTechnicalFacets.contains(facet.name) && !defaultFacetsRequested) continue;
                ArrayList keyList = new ArrayList(((Map)this.technicalFacetMap.get(matchedFacetName)).keySet());
                for (int i = from; i < to; ++i) {
                    LabelFrequency freq = new LabelFrequency();
                    freq.label = (String)keyList.get(i);
                    freq.count = ((Integer)((Map)this.technicalFacetMap.get(matchedFacetName)).get(freq.label)).intValue();
                    facet.fields.add(freq);
                }
                facetList.add(facet);
            }
        }
        facetList.sort((f1, f2) -> Integer.compare(f2.fields.size(), f1.fields.size()));
        return facetList;
    }
}

