/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import eu.europeana.api2.v2.schedule.SugarCRMPollingScheduler;
import eu.europeana.api2.v2.service.SugarCRMCache;
import eu.europeana.api2.v2.service.SugarCRMImporter;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.features.ObjectStorageClient;
import eu.europeana.features.S3ObjectStorageClient;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ImportResource(value={"classpath:corelib-db-context.xml", "classpath:corelib-solr-context.xml", "classpath:corelib-utils-context.xml", "classpath:corelib-web-context.xml", "classpath:spring-sugarcrmclient.xml"})
@EnableScheduling
@PropertySource(value={"classpath:europeana.properties"})
public class AppConfig {
    private static final Logger LOG = Logger.getLogger(AppConfig.class);
    @Value(value="${s3.key}")
    private String key;
    @Value(value="${s3.secret}")
    private String secret;
    @Value(value="${s3.region}")
    private String region;
    @Value(value="${s3.bucket}")
    private String bucket;

    @Bean
    public static PropertySourcesPlaceholderConfigurer properties() {
        PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer = new PropertySourcesPlaceholderConfigurer();
        propertySourcesPlaceholderConfigurer.setIgnoreResourceNotFound(true);
        propertySourcesPlaceholderConfigurer.setLocalOverride(true);
        propertySourcesPlaceholderConfigurer.setLocations(new Resource[]{new ClassPathResource("europeana.properties"), new ClassPathResource("europeana.user.properties")});
        return propertySourcesPlaceholderConfigurer;
    }

    @Bean
    public ApiKeyUtils apiKeyUtils() {
        return new ApiKeyUtils();
    }

    @Bean
    public SugarCRMPollingScheduler sugarCRMPollingScheduler() {
        return new SugarCRMPollingScheduler();
    }

    @Bean
    public SugarCRMImporter sugarCRMImporter() {
        return new SugarCRMImporter();
    }

    @Bean
    public SugarCRMCache sugarCRMCache() {
        return new SugarCRMCache();
    }

    @Bean(name={"api_object_storage_client"})
    public ObjectStorageClient objectStorageClient() {
        LOG.info((Object)"Creating new objectStorage client");
        return new S3ObjectStorageClient(this.key, this.secret, this.region, this.bucket);
    }
}

