/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.security;

import eu.europeana.api2.web.security.model.Api2UserDetails;
import eu.europeana.api2.web.security.model.ClientDetails;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.db.service.UserService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="api2_userDetailsService")
public class UserDetailsServiceImpl
implements UserDetailsService {
    @Resource
    private ApiKeyService apiKeyService;
    @Resource
    private UserService userService;

    public UserDetails loadUserByUsername(String key) throws UsernameNotFoundException {
        if (StringUtils.contains((String)key, (String)"@")) {
            User user = this.userService.findByEmail(key);
            if (user != null) {
                return new Api2UserDetails(user);
            }
        } else {
            try {
                ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)key));
                if (apiKey != null) {
                    return new ClientDetails(apiKey);
                }
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        throw new UsernameNotFoundException(key);
    }
}

