/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.controller;

import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import java.io.Serializable;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.approval.Approval;
import org.springframework.security.oauth2.provider.approval.ApprovalStore;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
@SessionAttributes(value={"authorizationRequest"})
public class AccessConfirmationController {
    @Resource
    private ApiKeyService apiKeyService;
    @Resource
    private ApprovalStore approvalStore;
    @Resource(name="api2_oauth2_clientDetailsService")
    private ClientDetailsService clientDetailsService;

    @RequestMapping(value={"/oauth/confirm_access"})
    public ModelAndView getAccessConfirmation(Map<String, Object> model, Principal principal) throws Exception {
        AuthorizationRequest clientAuth = (AuthorizationRequest)model.remove("authorizationRequest");
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientAuth.getClientId());
        ApiKey key = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)client.getClientId()));
        model.put("auth_request", clientAuth);
        model.put("client", client);
        model.put("appName", StringUtils.defaultIfBlank((String)key.getApplicationName(), (String)StringUtils.defaultIfBlank((String)key.getCompany(), (String)((String)((Object)key.getId())))));
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        for (String scope : clientAuth.getScope()) {
            scopes.put("scope." + scope, "false");
        }
        this.approvalStore.getApprovals(principal.getName(), client.getClientId()).stream().filter(approval -> clientAuth.getScope().contains(approval.getScope())).forEach(approval -> scopes.put("scope." + approval.getScope(), approval.getStatus() == Approval.ApprovalStatus.APPROVED ? "true" : "false"));
        model.put("scopes", scopes);
        return new ModelAndView("user/authorize", model);
    }

    @RequestMapping(value={"/oauth/error"})
    public String handleError(Map<String, Object> model) throws Exception {
        model.put("message", "There was a problem with the OAuth2 protocol");
        return "user/error";
    }

    @RequestMapping(value={"/oAuthLogin"})
    public String loginUserForm() {
        return "user/login";
    }
}

