/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.v2.model.VersionInfoResult;
import eu.europeana.corelib.search.SearchService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VersionController {
    private static final Logger LOG = Logger.getLogger(VersionController.class);

    @RequestMapping(value={"version", "/v2/version"}, method={RequestMethod.GET})
    public VersionInfoResult getVersion() {
        VersionInfoResult result = new VersionInfoResult();
        try {
            result.setApiBuildInfo(this.getVersion(VersionInfoResult.class) + " " + this.getCreationDate(VersionInfoResult.class));
            result.setCorelibBuildInfo(this.getVersion(SearchService.class) + " " + this.getCreationDate(SearchService.class));
        }
        catch (IOException | URISyntaxException e) {
            LOG.warn((Object)"Error retrieving api or corelib build information", (Throwable)e);
        }
        InputStream is = this.getClass().getResourceAsStream("/../../build.txt");
        if (is == null) {
            LOG.warn((Object)"No api2 build.txt file found!");
        } else {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append(' ');
                }
                result.setApiBuildInfo(sb.toString());
            }
            catch (IOException e) {
                LOG.error((Object)"Error reading API2 build.txt file", (Throwable)e);
            }
        }
        return result;
    }

    private String getVersion(Class clazz) {
        String result = clazz.getPackage().getImplementationVersion();
        if (result == null) {
            result = clazz.getPackage().getSpecificationVersion();
        }
        if (result == null) {
            result = this.stripVersionFileName(clazz.getProtectionDomain().getCodeSource().getLocation().getPath());
        }
        return result;
    }

    private String getCreationDate(Class clazz) throws IOException, URISyntaxException {
        Path file = Paths.get(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
        BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        ZoneId timezone = ZoneId.of("CET");
        LocalDateTime fileTime = LocalDateTime.ofInstant(attr.creationTime().toInstant(), timezone);
        StringBuilder timeString = new StringBuilder(fileTime.toLocalDate().toString());
        timeString.append(' ').append(fileTime.toLocalTime()).append(' ').append(timezone.getId());
        return timeString.toString();
    }

    private String stripVersionFileName(String fileName) {
        Pattern pattern = Pattern.compile("[\\d][.][.\\d*]*(-SNAPSHOT)?");
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }
}

