/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.v2.model.json.common.LabelFrequency;
import eu.europeana.api2.v2.model.json.view.submodel.SpellCheck;
import eu.europeana.api2.v2.utils.ModelUtils;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.CommonPropertyExtractor;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.ImagePropertyExtractor;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.SoundPropertyExtractor;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.VideoPropertyExtractor;
import eu.europeana.corelib.definitions.solr.SolrFacetType;
import eu.europeana.corelib.definitions.solr.TechnicalFacetType;
import eu.europeana.crf_faketags.extractor.MediaTypeEncoding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.response.SpellCheckResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModelUtils {
    public static final int FACET_LIMIT = 150;
    protected static final List<String> technicalFacetList = new ArrayList();
    protected static final List<String> solrFacetList = new ArrayList();
    protected static final List<String> enumFacetList = new ArrayList();

    public static String decodeFacetTag(Integer tag, boolean name) {
        MediaTypeEncoding mediaType = CommonPropertyExtractor.getType((Integer)tag);
        String mimeType = CommonPropertyExtractor.getMimeType((Integer)tag);
        if (StringUtils.isNotBlank((String)mimeType)) {
            return name ? "MIME_TYPE" : mimeType;
        }
        switch (1.$SwitchMap$eu$europeana$crf_faketags$extractor$MediaTypeEncoding[mediaType.ordinal()]) {
            case 1: {
                String label = ImagePropertyExtractor.getAspectRatio((int)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return name ? "IMAGE_ASPECTRATIO" : label;
                }
                label = ImagePropertyExtractor.getColor((int)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return name ? "COLOURPALETTE" : label;
                }
                label = ImagePropertyExtractor.getColorSpace((int)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return name ? "IMAGE_COLOUR" : label;
                }
                label = ImagePropertyExtractor.getSize((int)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return name ? "IMAGE_SIZE" : label;
                }
                return label;
            }
            case 2: {
                String label = SoundPropertyExtractor.getDuration((Integer)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return name ? "SOUND_DURATION" : label;
                }
                label = SoundPropertyExtractor.getQuality((Integer)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return name ? "SOUND_HQ" : label;
                }
                return "";
            }
            case 3: {
                String label = VideoPropertyExtractor.getDuration((Integer)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return name ? "VIDEO_DURATION" : label;
                }
                label = VideoPropertyExtractor.getQuality((Integer)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return name ? "VIDEO_HD" : label;
                }
                return "";
            }
        }
        return "";
    }

    public static boolean containsTechnicalFacet(String[] mixedFacets) {
        return ModelUtils.containsTechnicalFacet(Arrays.asList(mixedFacets));
    }

    public static boolean containsTechnicalFacet(List<String> mixedFacets) {
        return CollectionUtils.containsAny(mixedFacets, (Collection)technicalFacetList);
    }

    public static SpellCheck convertSpellCheck(SpellCheckResponse response) {
        if (response != null) {
            SpellCheck spellCheck = new SpellCheck();
            spellCheck.correctlySpelled = response.isCorrectlySpelled();
            for (SpellCheckResponse.Suggestion suggestion : response.getSuggestions()) {
                for (int i = 0; i < suggestion.getNumFound(); ++i) {
                    LabelFrequency value = new LabelFrequency();
                    value.label = (String)suggestion.getAlternatives().get(i);
                    value.count = ((Integer)suggestion.getAlternativeFrequencies().get(i)).longValue();
                    spellCheck.suggestions.add(value);
                }
            }
            return spellCheck;
        }
        return null;
    }

    public static Map<String, String[]> separateAndLimitFacets(String[] mixedFacetArray, boolean defaultFacetsRequested) {
        HashMap<String, String[]> facetListMap = new HashMap<String, String[]>();
        if (defaultFacetsRequested) {
            facetListMap.put("technicalfacets", technicalFacetList.toArray(new String[0]));
            facetListMap.put("solrfacets", solrFacetList.toArray(new String[0]));
        } else if (ArrayUtils.isNotEmpty((Object[])mixedFacetArray)) {
            facetListMap.put("technicalfacets", ((List)CollectionUtils.intersection((Collection)technicalFacetList, Arrays.asList(mixedFacetArray))).toArray(new String[0]));
            facetListMap.put("solrfacets", ((List)CollectionUtils.intersection((Collection)solrFacetList, Arrays.asList(mixedFacetArray))).toArray(new String[0]));
        }
        if (ArrayUtils.isNotEmpty((Object[])mixedFacetArray)) {
            List customSolrFacetList = (List)CollectionUtils.subtract(Arrays.asList(mixedFacetArray), (Collection)enumFacetList);
            if (customSolrFacetList.contains("DEFAULT")) {
                customSolrFacetList.remove("DEFAULT");
            }
            String[] customSolrFacets = customSolrFacetList.toArray(new String[0]);
            if (defaultFacetsRequested) {
                facetListMap.put("customfacets", ModelUtils.safelyLimitArray((String[])customSolrFacets, (int)(150 - enumFacetList.size())));
            } else {
                facetListMap.put("customfacets", ModelUtils.safelyLimitArray((String[])customSolrFacets, (int)(150 - (((String[])facetListMap.get("technicalfacets")).length + ((String[])facetListMap.get("solrfacets")).length))));
            }
        }
        return facetListMap;
    }

    private static String[] safelyLimitArray(String[] input, int limit) {
        if (limit >= input.length) {
            return input;
        }
        return Arrays.copyOfRange(input, 0, limit);
    }

    static {
        for (TechnicalFacetType technicalFacetType : TechnicalFacetType.values()) {
            technicalFacetList.add(technicalFacetType.name());
        }
        for (TechnicalFacetType technicalFacetType : SolrFacetType.values()) {
            solrFacetList.add(technicalFacetType.toString());
        }
        enumFacetList.addAll(technicalFacetList);
        enumFacetList.addAll(solrFacetList);
    }
}

