/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service;

import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.HierarchicalResult;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.neo4j.entity.Neo4jBean;
import eu.europeana.corelib.neo4j.entity.Neo4jStructBean;
import eu.europeana.corelib.neo4j.exception.Neo4JException;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.web.exception.EmailServiceException;
import eu.europeana.corelib.web.exception.EuropeanaException;
import eu.europeana.corelib.web.exception.ProblemType;
import eu.europeana.corelib.web.service.EmailService;
import eu.europeana.corelib.web.utils.RequestUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.servlet.ModelAndView;

public class HierarchyRunner {
    @Resource(name="corelib_web_emailService")
    private EmailService emailService;
    private static final int MAX_LIMIT = 100;
    private SearchService searchService;
    private final String SUBJECTPREFIX = "Europeana exception email handler: ";

    @Async
    public ModelAndView call(RecordType recordType, String rdfAbout, String profile, String wskey, int limit, int offset, String callback, HttpServletRequest request, HttpServletResponse response, Logger log, ApiKeyUtils apiKeyUtils, SearchService searchService) {
        LimitResponse limitResponse;
        this.searchService = searchService;
        log.info((Object)("Running thread for " + rdfAbout));
        long t0 = System.currentTimeMillis();
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        limit = Math.min(limit, 100);
        long t1 = System.currentTimeMillis();
        try {
            limitResponse = apiKeyUtils.checkLimit(wskey, request.getRequestURL().toString(), recordType, profile);
        }
        catch (ApiLimitException e) {
            response.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Limit: " + (System.currentTimeMillis() - t1)));
        }
        t1 = System.currentTimeMillis();
        HierarchicalResult hierarchicalResult = new HierarchicalResult(wskey, limitResponse.getRequestNumber());
        if (StringUtils.containsIgnoreCase((String)profile, (String)"params")) {
            hierarchicalResult.addParams(RequestUtils.getParameterMap((HttpServletRequest)request), new String[]{"wskey"});
            hierarchicalResult.addParam("profile", (Object)profile);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Init object: " + (System.currentTimeMillis() - t1)));
        }
        t1 = System.currentTimeMillis();
        try {
            long childrenCount;
            hierarchicalResult.self = searchService.getHierarchicalBean(rdfAbout);
            if (hierarchicalResult.self != null) {
                childrenCount = searchService.getChildrenCount(rdfAbout);
                if (hierarchicalResult.self.hasChildren().booleanValue() && childrenCount == 0L) {
                    throw new Neo4JException(ProblemType.NEO4J_INCONSISTENT_DATA, " for record " + rdfAbout);
                }
            } else {
                hierarchicalResult.success = false;
                response.setStatus(404);
                return JsonUtils.toJson((Object)new ApiError(wskey, String.format("Invalid record identifier: %s", rdfAbout), limitResponse.getRequestNumber()), (String)callback);
            }
            hierarchicalResult.self.setChildrenCount(Long.valueOf(childrenCount));
            if (log.isDebugEnabled()) {
                log.debug((Object)("get self: " + (System.currentTimeMillis() - t1)));
            }
            t1 = System.currentTimeMillis();
            if (recordType.equals((Object)RecordType.HIERARCHY_CHILDREN)) {
                if (hierarchicalResult.self.getChildrenCount() > 0L) {
                    hierarchicalResult.children = searchService.getChildren(rdfAbout, offset, limit);
                    if (hierarchicalResult.children == null || hierarchicalResult.children.isEmpty()) {
                        hierarchicalResult.message = "This record has no children";
                        hierarchicalResult.success = false;
                        response.setStatus(404);
                    } else {
                        this.addChildrenCount(hierarchicalResult.children);
                    }
                } else {
                    hierarchicalResult.message = "This record has no children";
                    hierarchicalResult.success = false;
                    response.setStatus(404);
                }
            } else if (recordType.equals((Object)RecordType.HIERARCHY_PARENT)) {
                if (hierarchicalResult.self == null || StringUtils.isBlank((String)hierarchicalResult.self.getParent())) {
                    hierarchicalResult.message = "This record has no parent";
                    hierarchicalResult.success = false;
                    response.setStatus(404);
                } else {
                    hierarchicalResult.parent = searchService.getHierarchicalBean(hierarchicalResult.self.getParent());
                    if (hierarchicalResult.parent != null) {
                        hierarchicalResult.parent.setChildrenCount(Long.valueOf(searchService.getChildrenCount(hierarchicalResult.parent.getId())));
                    }
                }
            } else if (recordType.equals((Object)RecordType.HIERARCHY_FOLLOWING_SIBLINGS)) {
                long tgetsiblings = System.currentTimeMillis();
                hierarchicalResult.followingSiblings = searchService.getFollowingSiblings(rdfAbout, limit);
                log.info((Object)("Get siblings: " + (System.currentTimeMillis() - tgetsiblings)));
                if (hierarchicalResult.followingSiblings == null || hierarchicalResult.followingSiblings.isEmpty()) {
                    hierarchicalResult.message = "This record has no following siblings";
                    hierarchicalResult.success = false;
                    response.setStatus(404);
                } else {
                    long tgetsiblingsCount = System.currentTimeMillis();
                    this.addChildrenCount(hierarchicalResult.followingSiblings);
                    log.info((Object)("Get siblingsCount: " + (System.currentTimeMillis() - tgetsiblingsCount)));
                }
            } else if (recordType.equals((Object)RecordType.HIERARCHY_PRECEDING_SIBLINGS)) {
                hierarchicalResult.precedingSiblings = searchService.getPrecedingSiblings(rdfAbout, limit);
                if (hierarchicalResult.precedingSiblings == null || hierarchicalResult.precedingSiblings.isEmpty()) {
                    hierarchicalResult.message = "This record has no preceding siblings";
                    hierarchicalResult.success = false;
                    response.setStatus(404);
                } else {
                    this.addChildrenCount(hierarchicalResult.precedingSiblings);
                }
            } else if (recordType.equals((Object)RecordType.HIERARCHY_ANCESTOR_SELF_SIBLINGS)) {
                Neo4jStructBean struct = searchService.getInitialStruct(rdfAbout);
                if (struct == null) {
                    hierarchicalResult.message = String.format("This record has no hierarchical structure %s", rdfAbout);
                    hierarchicalResult.success = false;
                    response.setStatus(404);
                } else {
                    String partialErrorMsg = "This record has no";
                    boolean hasParent = true;
                    boolean hasFollowing = true;
                    boolean hasPreceding = true;
                    if (struct.getParents() != null && !struct.getParents().isEmpty()) {
                        List tempParents = struct.getParents();
                        Collections.reverse(tempParents);
                        hierarchicalResult.ancestors = tempParents;
                    } else {
                        hasParent = false;
                    }
                    if (struct.getFollowingSiblings() != null && !struct.getFollowingSiblings().isEmpty()) {
                        hierarchicalResult.followingSiblings = struct.getFollowingSiblings();
                    } else {
                        hasFollowing = false;
                    }
                    if (struct.getPrecedingSiblings() != null && !struct.getPrecedingSiblings().isEmpty()) {
                        hierarchicalResult.precedingSiblings = struct.getPrecedingSiblings();
                    } else {
                        hasPreceding = false;
                    }
                    if (!hasParent) {
                        partialErrorMsg = partialErrorMsg + " parent";
                        if (!hasFollowing || !hasPreceding) {
                            partialErrorMsg = partialErrorMsg + " or";
                        }
                    }
                    if (!hasFollowing && !hasPreceding) {
                        partialErrorMsg = partialErrorMsg + " siblings";
                    } else if (hasFollowing && !hasPreceding) {
                        partialErrorMsg = partialErrorMsg + " preceding siblings";
                    } else if (!hasFollowing) {
                        partialErrorMsg = partialErrorMsg + " following siblings";
                    }
                    if (!(hasParent && hasFollowing && hasPreceding)) {
                        hierarchicalResult.message = partialErrorMsg;
                    }
                    if (struct.getPrecedingSiblingChildren() != null && !struct.getPrecedingSiblingChildren().isEmpty()) {
                        hierarchicalResult.precedingSiblingChildren = struct.getPrecedingSiblingChildren();
                    }
                    if (struct.getFollowingSiblingChildren() != null && !struct.getFollowingSiblingChildren().isEmpty()) {
                        hierarchicalResult.followingSiblingChildren = struct.getFollowingSiblingChildren();
                    }
                }
            }
        }
        catch (Neo4JException e) {
            response.setStatus(500);
            log.error((Object)("Neo4JException thrown: " + e.getMessage()));
            if (null != e.getCause()) {
                log.error((Object)("Cause: " + e.getCause().toString()));
            }
            return JsonUtils.toJson((Object)new ApiError(wskey, String.format("Neo4JException thrown: " + e.getMessage() + " for record %s", rdfAbout), -1L), (String)callback);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("get main: " + (System.currentTimeMillis() - t1)));
        }
        t1 = System.currentTimeMillis();
        hierarchicalResult.statsDuration = System.currentTimeMillis() - t0;
        ModelAndView json = JsonUtils.toJson((Object)hierarchicalResult, (String)callback);
        if (log.isDebugEnabled()) {
            log.debug((Object)("toJson: " + (System.currentTimeMillis() - t1)));
        }
        return json;
    }

    private void addChildrenCount(List<Neo4jBean> beans) throws Neo4JException {
        if (beans != null && beans.size() > 0) {
            for (Neo4jBean bean : beans) {
                if (!bean.hasChildren().booleanValue()) continue;
                bean.setChildrenCount(Long.valueOf(this.searchService.getChildrenCount(bean.getId())));
            }
        }
    }

    private void sendExceptionEmail(EuropeanaException e) {
        String newline = System.getProperty("line.separator");
        String header = "Europeana exception email handler: " + e.getProblem().getMessage();
        String body = e.getMessage() + newline + newline + ExceptionUtils.getStackTrace((Throwable)e);
        try {
            this.emailService.sendException(header, body);
        }
        catch (EmailServiceException es) {
            es.printStackTrace();
        }
    }
}

