/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.schedule;

import eu.europeana.api2.v2.service.SugarCRMImporter;
import eu.europeana.uim.sugarcrmclient.ws.exceptions.JIXBQueryResultException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;

public class SugarCRMPollingScheduler {
    private Logger log = Logger.getLogger(this.getClass());
    @Resource
    private SugarCRMImporter sugarCRMImporter;
    private boolean firstRunComplete = false;

    @PostConstruct
    public void scheduleFirstRun() {
        try {
            this.sugarCRMImporter.populateRepositoryFromScratch();
        }
        catch (JIXBQueryResultException e) {
            this.log.error((Object)("Re-population of MongoDB Cache from SugarCRM failed: " + e.getMessage()), (Throwable)e);
        }
        this.firstRunComplete = true;
    }

    @Scheduled(fixedRate=100000L)
    public void frequentUpdateTask() {
        if (this.firstRunComplete) {
            try {
                this.sugarCRMImporter.pollProviders();
                this.sugarCRMImporter.pollCollections();
            }
            catch (JIXBQueryResultException e) {
                this.log.error((Object)("Frequently scheduled update for provider/collections failed: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

