/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.v2.web.controller.SiteMapNotFoundException;
import eu.europeana.domain.StorageObject;
import eu.europeana.features.ObjectStorageClient;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jclouds.io.Payload;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SitemapController {
    private final Logger log = Logger.getLogger(this.getClass());
    public static String ACTIVE_SITEMAP_FILE = "europeana-sitemap-active-xml-file.txt";
    @Resource(name="api_object_storage_client")
    private ObjectStorageClient objectStorageClient;

    @RequestMapping(value={"/europeana-sitemap-index-hashed.xml"})
    public void handleSitemapIndexHashed(HttpServletResponse response) throws IOException {
        String cacheFile = "europeana-sitemap-index-hashed.xml";
        try {
            this.readCachedSitemap(response.getOutputStream(), this.objectStorageClient, cacheFile);
        }
        catch (SiteMapNotFoundException e) {
            this.log.error((Object)e);
            response.sendError(404);
        }
    }

    @RequestMapping(value={"/europeana-sitemap-hashed.xml"})
    public void handleSitemap(@RequestParam(value="from", required=true) String from, @RequestParam(value="to", required=true) String to, HttpServletResponse response) throws Exception {
        ServletOutputStream out = response.getOutputStream();
        String cacheFile = null;
        try {
            cacheFile = this.getActiveFile() + "?from=" + from + "&to=" + to;
        }
        catch (SiteMapNotFoundException e) {
            this.log.error((Object)(ACTIVE_SITEMAP_FILE + "could not be found"));
            response.sendError(404);
            out.println(e.toString());
        }
        try {
            this.readCachedSitemap(out, this.objectStorageClient, cacheFile);
        }
        catch (IOException e) {
            this.log.error((Object)e);
            response.sendError(500);
            out.println(e.toString());
        }
    }

    private void readCachedSitemap(ServletOutputStream out, ObjectStorageClient objectStorageClient, String cacheFile) throws IOException, SiteMapNotFoundException {
        InputStream in = null;
        Payload payload = null;
        try {
            StringWriter writer = new StringWriter();
            Optional storageObject = objectStorageClient.get(cacheFile);
            if (!storageObject.isPresent()) {
                throw new SiteMapNotFoundException("Error while reading sitemap file " + cacheFile + " from the ObjectStorage provider");
            }
            StorageObject storageObjectValue = (StorageObject)storageObject.get();
            payload = storageObjectValue.getPayload();
            in = payload.openStream();
            IOUtils.copy((InputStream)in, (Writer)writer);
            out.println(writer.toString());
            out.flush();
            in.close();
            payload.close();
        }
        catch (IOException e) {
            try {
                throw new IOException("Error while reading sitemap file " + cacheFile + " from the ObjectStorage provider", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(payload);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((Closeable)payload);
    }

    private String getActiveFile() throws IOException, SiteMapNotFoundException {
        String result = "";
        InputStream in = null;
        Payload payload = null;
        try {
            StringWriter writer = new StringWriter();
            Optional storageObject = this.objectStorageClient.get(ACTIVE_SITEMAP_FILE);
            if (!storageObject.isPresent()) {
                throw new SiteMapNotFoundException("Error while reading sitemap file " + ACTIVE_SITEMAP_FILE + " from the ObjectStorage provider");
            }
            StorageObject storageObjectValue = (StorageObject)storageObject.get();
            payload = storageObjectValue.getPayload();
            in = payload.openStream();
            IOUtils.copy((InputStream)in, (Writer)writer);
            result = writer.toString();
            in.close();
            payload.close();
        }
        catch (IOException e) {
            try {
                throw new IOException("Error while reading active sitemap file " + ACTIVE_SITEMAP_FILE + " from the ObjectStorage provider", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(payload);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((Closeable)payload);
        return result;
    }
}

