/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.security.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.utils.StringArrayUtils;
import java.util.Collection;
import java.util.Set;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;

public class OAuth2ClientDetails
extends BaseClientDetails {
    private static final long serialVersionUID = -5687602758230210358L;
    private Set<String> authGrantTypes = StringArrayUtils.toSet((String[])new String[]{"authorization_code", "implicit"});
    private Set<String> scope = StringArrayUtils.toSet((String[])new String[]{"read", "write"});

    public OAuth2ClientDetails(ApiKey apiKey) {
        this.setClientId((String)((Object)apiKey.getId()));
        this.setClientSecret(apiKey.getPrivateKey());
        this.setAuthorities((Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)apiKey.getLevel().getRoles()));
    }

    public boolean isSecretRequired() {
        return true;
    }

    @JsonIgnore
    public Set<String> getAuthorizedGrantTypes() {
        return this.authGrantTypes;
    }

    public Set<String> getScope() {
        return this.scope;
    }
}

