/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.domain.MediaFile;
import eu.europeana.corelib.web.service.MediaStorageService;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ContentReuseFrameworkController {
    @Resource
    private MediaStorageService mediaStorageService;
    @Resource
    private ControllerUtils controllerUtils;

    @RequestMapping(value={"/v2/thumbnail-by-url.json"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> thumbnailByUrl(@RequestParam(value="uri", required=false) String url, @RequestParam(value="size", required=false, defaultValue="FULL_DOC") String size, @RequestParam(value="type", required=false, defaultValue="IMAGE") String type, HttpServletResponse response) throws IOException {
        this.controllerUtils.addResponseHeaders(response);
        url = url == null ? "" : url;
        HttpHeaders headers = new HttpHeaders();
        String mediaFileId = this.computeResourceUrl(url, size);
        MediaFile mediaFile = this.mediaStorageService.retrieve(mediaFileId, Boolean.valueOf(true));
        byte[] mediaResponse = null;
        if (mediaFile != null) {
            mediaResponse = mediaFile.getContent();
            headers.setContentType(MediaType.IMAGE_JPEG);
        } else {
            headers.setContentType(MediaType.IMAGE_PNG);
            mediaResponse = this.getDefaultThumbnailForNotFoundResourceByType(type);
        }
        return new ResponseEntity((Object)mediaResponse, (MultiValueMap)headers, HttpStatus.OK);
    }

    private byte[] getImage(String path) {
        byte[] response = null;
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path));
            response = this.getByteArray(img, path.endsWith(".png") ? "png" : "gif");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    private byte[] getByteArray(BufferedImage bufferedImage, String formatName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, formatName, baos);
            baos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    private BufferedImage resizeImage(BufferedImage originalImage, int type, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    private String getMD5(String input) {
        String temp;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(input.getBytes());
            byte[] resultByte = messageDigest.digest();
            StringBuffer sb = new StringBuffer();
            for (byte aResultByte : resultByte) {
                sb.append(Integer.toString((aResultByte & 0xFF) + 256, 16).substring(1));
            }
            temp = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            temp = input;
        }
        return temp;
    }

    private byte[] getDefaultThumbnailForNotFoundResourceByType(String type) {
        switch (StringUtils.upperCase((String)type)) {
            case "IMAGE": {
                return this.getImage("/images/EU_thumbnails_image.png");
            }
            case "SOUND": {
                return this.getImage("/images/EU_thumbnails_sound.png");
            }
            case "VIDEO": {
                return this.getImage("/images/EU_thumbnails_video.png");
            }
            case "TEXT": {
                return this.getImage("/images/EU_thumbnails_text.png");
            }
            case "3D": {
                return this.getImage("/images/EU_thumbnails_3d.png");
            }
        }
        return this.getImage("/images/EU_thumbnails_image.png");
    }

    private String computeResourceUrl(String resourceUrl, String resourceSize) {
        return this.getMD5(resourceUrl) + "-" + (StringUtils.equalsIgnoreCase((String)resourceSize, (String)"w400") ? "LARGE" : "MEDIUM");
    }
}

