/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.CrfMetadataResult;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.domain.MediaFile;
import eu.europeana.corelib.web.service.ContentReuseFrameworkService;
import eu.europeana.corelib.web.service.MediaStorageService;
import eu.europeana.harvester.domain.SourceDocumentReferenceMetaInfo;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ContentReuseFrameworkController {
    @Resource
    private ContentReuseFrameworkService crfService;
    @Resource
    private MediaStorageService mediaStorageService;
    @Resource
    private ControllerUtils controllerUtils;

    @RequestMapping(value={"/v2/metadata-by-url.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView metadataByUrl(@RequestParam(value="url", required=true) String url, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        LimitResponse limitResponse;
        long t0 = System.currentTimeMillis();
        this.controllerUtils.addResponseHeaders(response);
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.OBJECT, null);
        }
        catch (ApiLimitException e) {
            response.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        CrfMetadataResult result = new CrfMetadataResult(wskey, limitResponse.getRequestNumber());
        SourceDocumentReferenceMetaInfo info = this.crfService.getMetadata(url);
        if (info != null) {
            result.imageMetaInfo = info.getImageMetaInfo();
        }
        result.statsDuration = System.currentTimeMillis() - t0;
        return JsonUtils.toJson((Object)result, (String)callback);
    }

    @RequestMapping(value={"/v2/thumbnail-by-url.json"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> thumbnailByUrl(@RequestParam(value="uri", required=false) String url, @RequestParam(value="size", required=false, defaultValue="FULL_DOC") String size, @RequestParam(value="type", required=false, defaultValue="IMAGE") String type, HttpServletResponse response) throws IOException {
        this.controllerUtils.addResponseHeaders(response);
        url = url == null ? "" : url;
        HttpHeaders headers = new HttpHeaders();
        String mediaFileId = this.computeResourceUrl(url, size);
        MediaFile mediaFile = this.mediaStorageService.retrieve(mediaFileId, Boolean.valueOf(true));
        byte[] mediaResponse = null;
        if (mediaFile != null) {
            mediaResponse = mediaFile.getContent();
            headers.setContentType(MediaType.IMAGE_JPEG);
        } else {
            headers.setContentType(MediaType.IMAGE_GIF);
            mediaResponse = this.getDefaultThumbnailForNotFoundResourceByType(type);
        }
        return new ResponseEntity((Object)mediaResponse, (MultiValueMap)headers, HttpStatus.OK);
    }

    private byte[] getImage(String path) {
        byte[] response = null;
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path));
            response = this.getByteArray(img);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    private byte[] getByteArray(BufferedImage bufferedImage) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "gif", baos);
            baos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    private BufferedImage resizeImage(BufferedImage originalImage, int type, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    private String getMD5(String input) {
        String temp;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(input.getBytes());
            byte[] resultByte = messageDigest.digest();
            StringBuffer sb = new StringBuffer();
            for (byte aResultByte : resultByte) {
                sb.append(Integer.toString((aResultByte & 0xFF) + 256, 16).substring(1));
            }
            temp = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            temp = input;
        }
        return temp;
    }

    private byte[] getDefaultThumbnailForNotFoundResourceByType(String type) {
        switch (StringUtils.upperCase((String)type)) {
            case "IMAGE": {
                return this.getImage("/images/item-image-large.gif");
            }
            case "SOUND": {
                return this.getImage("/images/item-sound-large.gif");
            }
            case "VIDEO": {
                return this.getImage("/images/item-video-large.gif");
            }
            case "TEXT": {
                return this.getImage("/images/item-text-large.gif");
            }
            case "3D": {
                return this.getImage("/images/item-3d-large.gif");
            }
        }
        return this.getImage("/images/item-image-large.gif");
    }

    private String computeResourceUrl(String resourceUrl, String resourceSize) {
        return this.getMD5(resourceUrl) + "-" + (StringUtils.equalsIgnoreCase((String)resourceSize, (String)"w400") ? "LARGE" : "MEDIUM");
    }
}

