/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.controller.mydata;

import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.json.ModificationConfirmation;
import eu.europeana.api2.v2.model.json.UserResults;
import eu.europeana.api2.v2.model.json.abstracts.UserObject;
import eu.europeana.api2.v2.model.json.user.Tag;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.api2.web.controller.abstracts.AbstractUserController;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.definitions.db.entity.relational.SocialTag;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.definitions.db.entity.relational.abstracts.EuropeanaUserObject;
import eu.europeana.corelib.definitions.exception.Neo4JException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Api(value="my_data", description=" ")
public class MyDataTagController
extends AbstractUserController {
    private Logger log = Logger.getLogger(MyDataTagController.class);

    @SwaggerIgnore
    @RequestMapping(value={"/mydata/tag"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView list(@RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="tag", required=false) String tagFilter, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserResults response = new UserResults(principal.getName());
        try {
            User user = this.getUserByApiId(principal.getName());
            if (user != null) {
                response.items = new ArrayList();
                response.username = user.getUserName();
                List tags = StringUtils.isNotBlank((String)tagFilter) ? this.userService.findSocialTagsByTag((Long)user.getId(), tagFilter) : (StringUtils.isNotBlank((String)europeanaId) ? this.userService.findSocialTagsByEuropeanaId((Long)user.getId(), europeanaId) : new ArrayList(user.getSocialTags()));
                response.itemsCount = tags.size();
                for (SocialTag item : tags) {
                    Tag tag = new Tag();
                    this.copyUserObjectData(response.apikey, (UserObject)tag, (EuropeanaUserObject)item);
                    tag.tag = item.getTag();
                    response.items.add(tag);
                }
                return JsonUtils.toJson((Object)response, (String)callback);
            }
            response.success = false;
            response.error = "Invalid credentials";
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="shows the user's tag cloud", nickname="showMyDataTagcloud")
    @RequestMapping(value={"/mydata/tag/cloud"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView listDistinct(@RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserResults response = new UserResults(principal.getName());
        User user = this.getUserByApiId(principal.getName());
        if (user != null) {
            try {
                response.items = this.userService.createSocialTagCloud((Long)user.getId());
                response.itemsCount = response.items.size();
                response.success = true;
            }
            catch (DatabaseException e) {
                response.success = false;
                response.error = e.getMessage();
            }
            response.username = user.getUserName();
        } else {
            response.success = false;
            response.error = "Invalid credentials";
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="lets the user create a new data tag", nickname="createMyDataTag")
    @RequestMapping(value={"mydata/tag"}, produces={"application/json"}, method={RequestMethod.POST})
    public ModelAndView create(@RequestParam(value="europeanaid", required=true) String europeanaId, @RequestParam(value="tag", required=true) String tag, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(principal.getName());
        User user = this.getUserByApiId(principal.getName());
        if (user != null) {
            try {
                this.userService.createSocialTag((Long)user.getId(), europeanaId, tag);
                response.success = true;
            }
            catch (DatabaseException e) {
                response.success = false;
                response.error = e.getMessage();
            }
            catch (Neo4JException e) {
                this.log.error((Object)("Neo4JException thrown: " + e.getMessage()));
                this.log.error((Object)("Cause: " + e.getCause()));
            }
        } else {
            response.success = false;
            response.error = "Invalid credentials";
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="lets the user delete a data tag", nickname="deleteMyDataTag")
    @RequestMapping(value={"/mydata/tag"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ModelAndView delete(@RequestParam(value="tagid", required=false) Long tagId, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(principal.getName());
        try {
            User user = this.getUserByApiId(principal.getName());
            if (user != null) {
                if (tagId != null) {
                    this.userService.removeSocialTag((Long)user.getId(), tagId);
                } else if (StringUtils.isNotBlank((String)europeanaId) || StringUtils.isNotBlank((String)tag)) {
                    this.userService.removeSocialTag((Long)user.getId(), europeanaId, tag);
                }
                response.success = true;
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }
}

