/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.json.BasicObjectResult;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.exception.LimitReachedException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.exception.Neo4JException;
import eu.europeana.corelib.edm.exceptions.MongoDBException;
import eu.europeana.corelib.edm.exceptions.MongoRuntimeException;
import eu.europeana.corelib.edm.exceptions.SolrTypeException;
import eu.europeana.corelib.search.SearchService;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/v2/basicrecord"})
public class BasicObjectController {
    @Resource
    private ApiKeyService apiKeyService;
    @Resource
    private SearchService searchService;
    private Logger log = Logger.getLogger(BasicObjectController.class);

    @ApiOperation(value="returns single item")
    @RequestMapping(value={"/{collectionId}/{recordId}.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView record(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="full") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        String europeanaObjectId = "/" + collectionId + "/" + recordId;
        long requestNumber = 0L;
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)wskey));
            if (apiKey == null) {
                return JsonUtils.toJson((Object)new ApiError(wskey, "Unregistered user"), (String)callback);
            }
            apiKey.getUsageLimit();
            requestNumber = this.apiKeyService.checkReachedLimit(apiKey);
        }
        catch (DatabaseException e) {
            return JsonUtils.toJson((Object)new ApiError(wskey, e.getMessage(), requestNumber), (String)callback);
        }
        catch (LimitReachedException e) {
            return JsonUtils.toJson((Object)new ApiError(wskey, e.getMessage(), e.getRequested()), (String)callback);
        }
        BasicObjectResult objectResult = new BasicObjectResult(wskey, requestNumber);
        objectResult.object = new HashMap();
        try {
            FullBean bean = this.searchService.findById(europeanaObjectId, true);
            if (bean == null) {
                bean = this.searchService.resolve(europeanaObjectId, true);
            }
            if (bean == null) {
                response.setStatus(404);
                return JsonUtils.toJson((Object)new ApiError(wskey, "Invalid record identifier: " + europeanaObjectId, requestNumber), (String)callback);
            }
        }
        catch (SolrTypeException e) {
            return JsonUtils.toJson((Object)new ApiError(wskey, e.getMessage(), requestNumber), (String)callback);
        }
        catch (MongoDBException e) {
            return JsonUtils.toJson((Object)new ApiError(wskey, e.getMessage(), requestNumber), (String)callback);
        }
        catch (MongoRuntimeException re) {
            return JsonUtils.toJson((Object)new ApiError(wskey, re.getMessage(), requestNumber), (String)callback);
        }
        catch (Neo4JException e) {
            this.log.error((Object)("Neo4JException thrown: " + e.getMessage()));
            this.log.error((Object)("Cause: " + e.getCause()));
        }
        return JsonUtils.toJson((Object)objectResult, (String)callback);
    }
}

