/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.controller.user;

import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.json.ModificationConfirmation;
import eu.europeana.api2.v2.model.json.UserResults;
import eu.europeana.api2.v2.model.json.abstracts.UserObject;
import eu.europeana.api2.v2.model.json.user.Tag;
import eu.europeana.api2.web.controller.abstracts.AbstractUserController;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.definitions.db.entity.relational.SocialTag;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.definitions.db.entity.relational.abstracts.EuropeanaUserObject;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/user/tag"})
@Api(value="my_europeana", description=" ")
public class UserTagController
extends AbstractUserController {
    @ApiOperation(value="lists a user's data tags", nickname="listUserTags")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView list(@RequestParam(value="tag", required=false) String tagFilter, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.list(null, tagFilter, callback, principal);
    }

    @ApiOperation(value="lists a user's data tags", nickname="listUserTags")
    @RequestMapping(value={"/{collectionId}/{recordId}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView list(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="tag", required=false) String tagFilter, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.list(EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId), tagFilter, callback, principal);
    }

    private ModelAndView list(String europeanaId, String tagFilter, String callback, Principal principal) {
        UserResults response = new UserResults(this.getApiId(principal));
        try {
            User user = this.userService.findByEmail(principal.getName());
            if (user != null) {
                response.items = new ArrayList();
                response.username = user.getUserName();
                List tags = StringUtils.isNotBlank((String)tagFilter) ? this.userService.findSocialTagsByTag((Long)user.getId(), tagFilter) : (StringUtils.isNotBlank((String)europeanaId) ? this.userService.findSocialTagsByEuropeanaId((Long)user.getId(), europeanaId) : new ArrayList(user.getSocialTags()));
                response.itemsCount = tags.size();
                for (SocialTag item : tags) {
                    Tag tag = new Tag();
                    this.copyUserObjectData(response.apikey, (UserObject)tag, (EuropeanaUserObject)item);
                    tag.tag = item.getTag();
                    response.items.add(tag);
                }
            } else {
                response.success = false;
                response.error = "User Profile not retrievable...";
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="shows the user's tag cloud", nickname="showUsersTagcloud")
    @RequestMapping(value={"/cloud"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView listDistinct(@RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserResults response = new UserResults(this.getApiId(principal));
        try {
            User user = this.userService.findByEmail(principal.getName());
            if (user != null) {
                response.items = this.userService.createSocialTagCloud((Long)user.getId());
                response.itemsCount = response.items.size();
                response.success = true;
                response.username = user.getUserName();
            } else {
                response.success = false;
                response.error = "User Profile not retrievable...";
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="creates a new data tag for a user", nickname="createUserTag")
    @RequestMapping(value={"/{collectionId}/{recordId}"}, produces={"application/json"}, method={RequestMethod.POST})
    public ModelAndView create(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="tag", required=true) String tag, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        User user = this.userService.findByEmail(principal.getName());
        ModificationConfirmation response = new ModificationConfirmation(this.getApiId(principal));
        if (user != null) {
            try {
                this.userService.createSocialTag((Long)user.getId(), EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId), tag);
                response.success = true;
            }
            catch (DatabaseException e) {
                response.success = false;
                response.error = e.getMessage();
            }
        } else {
            response.success = false;
            response.error = "User Profile not retrievable...";
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="deletes a data tag for a user", nickname="deleteUserTag")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.DELETE})
    public ModelAndView delete(@RequestParam(value="tag", required=true) String tag, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.delete((Long)null, tag, null, callback, principal);
    }

    @ApiOperation(value="deletes a data tag for a user", nickname="deleteUserTag")
    @RequestMapping(value={"/{tagId}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ModelAndView delete(@PathVariable Long tagId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.delete(tagId, null, null, callback, principal);
    }

    @ApiOperation(value="deletes a data tag for a user", nickname="deleteUserTag")
    @RequestMapping(value={"/{collectionId}/{recordId}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ModelAndView delete(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.delete((Long)null, tag, EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId), callback, principal);
    }

    private ModelAndView delete(Long tagId, String tag, String europeanaId, String callback, Principal principal) {
        User user = this.userService.findByEmail(principal.getName());
        ModificationConfirmation response = new ModificationConfirmation(this.getApiId(principal));
        if (user != null) {
            try {
                if (tagId != null) {
                    this.userService.removeSocialTag((Long)user.getId(), tagId);
                } else if (StringUtils.isNotBlank((String)europeanaId) || StringUtils.isNotBlank((String)tag)) {
                    this.userService.removeSocialTag((Long)user.getId(), europeanaId, tag);
                }
                response.success = true;
            }
            catch (DatabaseException e) {
                response.success = false;
                response.error = e.getMessage();
            }
        } else {
            response.success = false;
            response.error = "User Profile not retrievable...";
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }
}

